/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent.support.filtering;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.regex.Regex;

public class FilterContext {
    private String property;
    private List<String[]> matchings;
    private Boolean write = null;
    private boolean match = false;
    private FilterContext parent;
    private Type type = Type.VALUE;

    public FilterContext(String property, FilterContext parent) {
        this.property = property;
        this.parent = parent;
    }

    public void reset(String property) {
        this.property = property;
        this.write = null;
        if (this.matchings != null) {
            this.matchings.clear();
        }
        this.match = false;
        this.type = Type.VALUE;
    }

    public void reset(String property, FilterContext parent) {
        this.reset(property);
        this.parent = parent;
        if (parent.isMatch()) {
            this.match = true;
        }
    }

    public FilterContext parent() {
        return this.parent;
    }

    public List<String[]> matchings() {
        return this.matchings;
    }

    public void addMatching(String[] matching) {
        if (this.matchings == null) {
            this.matchings = new ArrayList<String[]>();
        }
        this.matchings.add(matching);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isArray() {
        return Type.ARRAY.equals((Object)this.type);
    }

    public void initArray() {
        this.type = Type.ARRAY;
    }

    public boolean isObject() {
        return Type.OBJECT.equals((Object)this.type);
    }

    public void initObject() {
        this.type = Type.OBJECT;
    }

    public boolean isArrayOfObject() {
        return Type.ARRAY_OF_OBJECT.equals((Object)this.type);
    }

    public void initArrayOfObject() {
        this.type = Type.ARRAY_OF_OBJECT;
    }

    public boolean isMatch() {
        return this.match;
    }

    public boolean include() {
        if (this.write == null) {
            if (this.parent != null) {
                if (this.parent.isMatch()) {
                    this.write = true;
                    this.match = true;
                    return this.write;
                }
                if (this.parent.matchings() != null) {
                    for (String[] matcher : this.parent.matchings()) {
                        if (matcher.length <= 0) continue;
                        String field = matcher[0];
                        if ("**".equals(field)) {
                            this.addMatching(matcher);
                        }
                        if (field == null || !Regex.simpleMatch(field, this.property)) continue;
                        int remaining = matcher.length - 1;
                        if (remaining == 0) {
                            this.write = true;
                            this.match = true;
                            return this.write;
                        }
                        String[] submatching = new String[remaining];
                        System.arraycopy(matcher, 1, submatching, 0, remaining);
                        this.addMatching(submatching);
                    }
                }
            } else {
                this.write = true;
            }
            if (this.write == null) {
                this.write = false;
            }
        }
        return this.write;
    }

    public void writePath(JsonGenerator generator) throws IOException {
        if (this.parent != null) {
            this.parent.writePath(generator);
        }
        if (this.write == null || !this.write.booleanValue()) {
            this.write = true;
            if (this.property == null) {
                generator.writeStartObject();
            } else {
                generator.writeFieldName(this.property);
                if (this.isArray()) {
                    generator.writeStartArray();
                } else if (this.isObject() || this.isArrayOfObject()) {
                    generator.writeStartObject();
                }
            }
        }
    }

    protected static enum Type {
        VALUE,
        OBJECT,
        ARRAY,
        ARRAY_OF_OBJECT;

    }
}

