/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.object.ObjectMapper;

public class MergeResult {
    private final boolean simulate;
    private final boolean updateAllTypes;
    private final List<String> conflicts = new ArrayList<String>();
    private final List<FieldMapper> newFieldMappers = new ArrayList<FieldMapper>();
    private final List<ObjectMapper> newObjectMappers = new ArrayList<ObjectMapper>();

    public MergeResult(boolean simulate, boolean updateAllTypes) {
        this.simulate = simulate;
        this.updateAllTypes = updateAllTypes;
    }

    public void addFieldMappers(Collection<FieldMapper> fieldMappers) {
        assert (!this.simulate());
        this.newFieldMappers.addAll(fieldMappers);
    }

    public void addObjectMappers(Collection<ObjectMapper> objectMappers) {
        assert (!this.simulate());
        this.newObjectMappers.addAll(objectMappers);
    }

    public Collection<FieldMapper> getNewFieldMappers() {
        return this.newFieldMappers;
    }

    public Collection<ObjectMapper> getNewObjectMappers() {
        return this.newObjectMappers;
    }

    public boolean simulate() {
        return this.simulate;
    }

    public boolean updateAllTypes() {
        return this.updateAllTypes;
    }

    public void addConflict(String mergeFailure) {
        this.conflicts.add(mergeFailure);
    }

    public boolean hasConflicts() {
        return !this.conflicts.isEmpty();
    }

    public String[] buildConflicts() {
        return this.conflicts.toArray(Strings.EMPTY_ARRAY);
    }
}

