/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.ipc.gradle;

import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.foundation.ipc.gradle.ExecuteGradleCommandClientProtocol;
import org.gradle.foundation.ipc.gradle.GradleClient;
import org.gradle.foundation.ipc.gradle.TaskListClientProtocol;

public class IPCUtilities {
    private static final Logger LOGGER = Logging.getLogger(IPCUtilities.class);

    public static void invokeExecuteGradleClient(Gradle gradle) {
        Integer port = IPCUtilities.getPort(gradle);
        if (port == null) {
            return;
        }
        ExecuteGradleCommandClientProtocol protocol = new ExecuteGradleCommandClientProtocol(gradle);
        GradleClient client = new GradleClient();
        client.start(protocol, port);
    }

    private static Integer getPort(Gradle gradle) {
        String portText = (String)gradle.getStartParameter().getSystemPropertiesArgs().get("PortNumber");
        if (portText == null) {
            LOGGER.error("Failed to set PortNumber system property");
            return null;
        }
        try {
            return Integer.parseInt(portText);
        }
        catch (NumberFormatException e) {
            LOGGER.error("Invalid PortNumber system property", (Throwable)e);
            return null;
        }
    }

    public static void invokeTaskListGradleClient(Gradle gradle) {
        Integer port = IPCUtilities.getPort(gradle);
        if (port == null) {
            return;
        }
        TaskListClientProtocol protocol = new TaskListClientProtocol(gradle);
        GradleClient client = new GradleClient();
        client.start(protocol, port);
    }
}

