/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.model;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.File;
import java.util.Iterator;
import org.gradle.api.Action;
import org.gradle.language.base.FunctionalSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.ProjectSourceSet;
import org.gradle.language.base.internal.registry.LanguageRegistration;
import org.gradle.language.base.internal.registry.LanguageRegistry;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.model.Defaults;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.internal.ComponentSpecInternal;

public class ComponentRules
extends RuleSource {
    @Defaults
    void initializeSourceSets(ComponentSpec component, LanguageRegistry languageRegistry, LanguageTransformContainer languageTransforms) {
        Iterator i$ = languageRegistry.iterator();
        while (i$.hasNext()) {
            LanguageRegistration languageRegistration = (LanguageRegistration)i$.next();
            ComponentSourcesRegistrationAction.create(languageRegistration, languageTransforms).execute((ComponentSpecInternal)component);
        }
    }

    @Defaults
    void applyDefaultSourceConventions(ComponentSpec component) {
        FunctionalSourceSet functionalSourceSet = ((ComponentSpecInternal)component).getFunctionalSourceSet();
        component.getSources().afterEach((Action)new AddDefaultSourceLocation(functionalSourceSet));
    }

    @Defaults
    void addSourcesSetsToProjectSourceSet(ComponentSpec component, final ProjectSourceSet projectSourceSet) {
        ((ComponentSpecInternal)component).getFunctionalSourceSet().whenObjectAdded((Action)new Action<LanguageSourceSet>(){

            public void execute(LanguageSourceSet languageSourceSet) {
                projectSourceSet.add(languageSourceSet);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddDefaultSourceLocation
    implements Action<LanguageSourceSet> {
        private FunctionalSourceSet functionalSourceSet;

        public AddDefaultSourceLocation(FunctionalSourceSet functionalSourceSet) {
            this.functionalSourceSet = functionalSourceSet;
        }

        public void execute(LanguageSourceSet languageSourceSet) {
            if (languageSourceSet.getSource().getSrcDirs().isEmpty()) {
                String defaultSourceDir = this.calculateDefaultPath(languageSourceSet);
                languageSourceSet.getSource().srcDir((Object)defaultSourceDir);
            }
        }

        private String calculateDefaultPath(LanguageSourceSet languageSourceSet) {
            return Joiner.on((String)File.separator).skipNulls().join((Object)this.functionalSourceSet.getBaseDir().getPath(), (Object)"src", new Object[]{Strings.emptyToNull((String)languageSourceSet.getParentName()), Strings.emptyToNull((String)languageSourceSet.getName())});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentSourcesRegistrationAction<U extends LanguageSourceSet>
    implements Action<ComponentSpecInternal> {
        private final LanguageRegistration<U> languageRegistration;
        private final LanguageTransformContainer languageTransforms;

        private ComponentSourcesRegistrationAction(LanguageRegistration<U> registration, LanguageTransformContainer languageTransforms) {
            this.languageRegistration = registration;
            this.languageTransforms = languageTransforms;
        }

        public static <U extends LanguageSourceSet> ComponentSourcesRegistrationAction<U> create(LanguageRegistration<U> registration, LanguageTransformContainer languageTransforms) {
            return new ComponentSourcesRegistrationAction<U>(registration, languageTransforms);
        }

        public void execute(ComponentSpecInternal componentSpecInternal) {
            this.registerLanguageTypes(componentSpecInternal);
        }

        void registerLanguageTypes(ComponentSpecInternal component) {
            Iterator i$ = this.languageTransforms.iterator();
            while (i$.hasNext()) {
                LanguageTransform languageTransform = (LanguageTransform)i$.next();
                if (!languageTransform.getSourceSetType().equals(this.languageRegistration.getSourceSetType()) || !component.getInputTypes().contains(languageTransform.getOutputType())) continue;
                component.getSources().create(this.languageRegistration.getName(), this.languageRegistration.getSourceSetType());
                return;
            }
        }
    }
}

