/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrapper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.sonar.batch.bootstrapper.BootstrapClassLoader;
import org.sonar.batch.bootstrapper.BootstrapException;
import org.sonar.batch.bootstrapper.BootstrapperIOUtils;
import org.sonar.batch.bootstrapper.BootstrapperVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bootstrapper {
    private static final String VERSION_PATH = "/api/server/version";
    private static final String BATCH_PATH = "/batch/";
    public static final int CONNECT_TIMEOUT_MILLISECONDS = 30000;
    public static final int READ_TIMEOUT_MILLISECONDS = 60000;
    private File bootDir;
    private String serverUrl;
    private String productToken;
    private String serverVersion;

    public Bootstrapper(String productToken, String serverUrl, File workDir) {
        this.productToken = productToken;
        this.bootDir = new File(workDir, "batch");
        this.bootDir.mkdirs();
        this.serverUrl = serverUrl.endsWith("/") ? serverUrl.substring(0, serverUrl.length() - 1) : serverUrl;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getServerVersion() {
        if (this.serverVersion == null) {
            try {
                this.serverVersion = this.remoteContent(VERSION_PATH);
            }
            catch (IOException e) {
                throw new BootstrapException(e.getMessage(), e);
            }
        }
        return this.serverVersion;
    }

    public BootstrapClassLoader createClassLoader(URL[] urls, ClassLoader parent, String ... unmaskedPackages) {
        BootstrapClassLoader classLoader = new BootstrapClassLoader(parent, unmaskedPackages);
        List<File> files = this.downloadBatchFiles();
        for (URL url : urls) {
            classLoader.addURL(url);
        }
        for (File file : files) {
            try {
                classLoader.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new BootstrapException(e);
            }
        }
        return classLoader;
    }

    private void remoteContentToFile(String path, File toFile) {
        InputStream input = null;
        FileOutputStream output = null;
        String fullUrl = this.serverUrl + path;
        try {
            HttpURLConnection connection = this.newHttpConnection(new URL(fullUrl));
            output = new FileOutputStream(toFile, false);
            input = connection.getInputStream();
            BootstrapperIOUtils.copyLarge(input, output);
        }
        catch (IOException e) {
            try {
                BootstrapperIOUtils.closeQuietly(output);
                BootstrapperIOUtils.deleteFileQuietly(toFile);
                throw new BootstrapException("Fail to download the file: " + fullUrl, e);
            }
            catch (Throwable throwable) {
                BootstrapperIOUtils.closeQuietly(input);
                BootstrapperIOUtils.closeQuietly(output);
                throw throwable;
            }
        }
        BootstrapperIOUtils.closeQuietly(input);
        BootstrapperIOUtils.closeQuietly(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String remoteContent(String path) throws IOException {
        String fullUrl = this.serverUrl + path;
        HttpURLConnection conn = this.newHttpConnection(new URL(fullUrl));
        InputStreamReader reader = new InputStreamReader((InputStream)conn.getContent());
        try {
            int statusCode = conn.getResponseCode();
            if (statusCode != 200) {
                throw new IOException("Status returned by url : '" + fullUrl + "' is invalid : " + statusCode);
            }
            String string = BootstrapperIOUtils.toString(reader);
            return string;
        }
        finally {
            BootstrapperIOUtils.closeQuietly(reader);
            conn.disconnect();
        }
    }

    String getUserAgent() {
        return "sonar-bootstrapper/" + BootstrapperVersion.getVersion() + " " + this.productToken;
    }

    HttpURLConnection newHttpConnection(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(60000);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestMethod("GET");
        connection.setRequestProperty("User-Agent", this.getUserAgent());
        return connection;
    }

    private List<File> downloadBatchFiles() {
        try {
            ArrayList<File> files = new ArrayList<File>();
            String libs = this.remoteContent(BATCH_PATH);
            for (String lib : libs.split(",")) {
                File file = new File(this.bootDir, lib);
                this.remoteContentToFile(BATCH_PATH + lib, file);
                files.add(file);
            }
            return files;
        }
        catch (Exception e) {
            throw new BootstrapException(e);
        }
    }
}

