/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.gradle.api.NamedDomainObjectList;
import org.gradle.api.Namer;
import org.gradle.api.internal.DefaultNamedDomainObjectCollection;
import org.gradle.api.internal.collections.CollectionEventRegister;
import org.gradle.api.internal.collections.CollectionFilter;
import org.gradle.api.internal.collections.FilteredList;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.reflect.Instantiator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNamedDomainObjectList<T>
extends DefaultNamedDomainObjectCollection<T>
implements NamedDomainObjectList<T> {
    public DefaultNamedDomainObjectList(DefaultNamedDomainObjectList<? super T> objects, CollectionFilter<T> filter, Instantiator instantiator, Namer<? super T> namer) {
        super(objects, filter, instantiator, namer);
    }

    public DefaultNamedDomainObjectList(Class<T> type, CollectionEventRegister<T> collectionEventRegister, Instantiator instantiator, Namer<? super T> namer) {
        super(type, new ArrayList(), collectionEventRegister, new DefaultNamedDomainObjectCollection.UnfilteredIndex(), instantiator, namer);
    }

    public DefaultNamedDomainObjectList(Class<T> type, Instantiator instantiator, Namer<? super T> namer) {
        super(type, new ArrayList(), instantiator, namer);
    }

    @Override
    public void add(int index, T element) {
        this.assertMutable();
        this.assertCanAdd(element);
        this.getStore().add(index, element);
        this.didAdd(element);
        this.getEventRegister().getAddAction().execute(element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.assertMutable();
        boolean changed = false;
        int current = index;
        for (T t : c) {
            if (this.hasWithName(this.getNamer().determineName(t))) continue;
            this.getStore().add(current, t);
            this.didAdd(t);
            this.getEventRegister().getAddAction().execute(t);
            changed = true;
            ++current;
        }
        return changed;
    }

    @Override
    protected List<T> getStore() {
        return (List)super.getStore();
    }

    @Override
    public T get(int index) {
        return (T)this.getStore().get(index);
    }

    @Override
    public T set(int index, T element) {
        this.assertMutable();
        this.assertCanAdd(element);
        T oldElement = this.getStore().set(index, element);
        if (oldElement != null) {
            this.didRemove(oldElement);
        }
        this.getEventRegister().getRemoveAction().execute(oldElement);
        this.didAdd(element);
        this.getEventRegister().getAddAction().execute(element);
        return oldElement;
    }

    @Override
    public T remove(int index) {
        this.assertMutable();
        Object element = this.getStore().remove(index);
        if (element != null) {
            this.didRemove(element);
        }
        this.getEventRegister().getRemoveAction().execute(element);
        return (T)element;
    }

    @Override
    public int indexOf(Object o) {
        return this.getStore().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getStore().lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ListIteratorImpl(this.getStore().listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ListIteratorImpl(this.getStore().listIterator(index));
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return Collections.unmodifiableList(this.getStore().subList(fromIndex, toIndex));
    }

    @Override
    protected <S extends T> Collection<S> filteredStore(CollectionFilter<S> filter) {
        return new FilteredList(this, filter);
    }

    @Override
    public NamedDomainObjectList<T> matching(Closure spec) {
        return this.matching(Specs.convertClosureToSpec((Closure)spec));
    }

    @Override
    public NamedDomainObjectList<T> matching(Spec<? super T> spec) {
        return new DefaultNamedDomainObjectList<T>(this, this.createFilter(spec), this.getInstantiator(), this.getNamer());
    }

    @Override
    public <S extends T> NamedDomainObjectList<S> withType(Class<S> type) {
        return new DefaultNamedDomainObjectList<S>(this, this.createFilter(type), this.getInstantiator(), this.getNamer());
    }

    @Override
    public List<T> findAll(Closure cl) {
        return this.findAll(cl, new ArrayList());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListIteratorImpl
    implements ListIterator<T> {
        private final ListIterator<T> iterator;
        private T lastElement;

        public ListIteratorImpl(ListIterator<T> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T next() {
            this.lastElement = this.iterator.next();
            return this.lastElement;
        }

        @Override
        public T previous() {
            this.lastElement = this.iterator.previous();
            return this.lastElement;
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void add(T t) {
            DefaultNamedDomainObjectList.this.assertMutable();
            DefaultNamedDomainObjectList.this.assertCanAdd(t);
            this.iterator.add(t);
            DefaultNamedDomainObjectList.this.didAdd(t);
            DefaultNamedDomainObjectList.this.getEventRegister().getAddAction().execute(t);
        }

        @Override
        public void remove() {
            DefaultNamedDomainObjectList.this.assertMutable();
            this.iterator.remove();
            DefaultNamedDomainObjectList.this.didRemove(this.lastElement);
            DefaultNamedDomainObjectList.this.getEventRegister().getRemoveAction().execute(this.lastElement);
            this.lastElement = null;
        }

        @Override
        public void set(T t) {
            DefaultNamedDomainObjectList.this.assertMutable();
            DefaultNamedDomainObjectList.this.assertCanAdd(t);
            this.iterator.set(t);
            DefaultNamedDomainObjectList.this.didRemove(this.lastElement);
            DefaultNamedDomainObjectList.this.getEventRegister().getRemoveAction().execute(this.lastElement);
            DefaultNamedDomainObjectList.this.didAdd(t);
            DefaultNamedDomainObjectList.this.getEventRegister().getAddAction().execute(t);
            this.lastElement = null;
        }
    }
}

