/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.cache.HeapProportionalSizer;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.cache.internal.CacheDecorator;
import org.gradle.cache.internal.FileLock;
import org.gradle.cache.internal.MultiProcessSafePersistentIndexedCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryTaskArtifactCache
implements CacheDecorator {
    private static final Logger LOG = Logging.getLogger(InMemoryTaskArtifactCache.class);
    private static final Object NULL = new Object();
    private static final Map<String, Integer> CACHE_CAPS = new CacheCapSizer().calculateCaps();
    private final Object lock = new Object();
    private final Cache<String, Cache<Object, Object>> cache = CacheBuilder.newBuilder().maximumSize((long)(CACHE_CAPS.size() * 2)).build();
    private final Map<String, FileLock.State> states = new HashMap<String, FileLock.State>();

    @Override
    public <K, V> MultiProcessSafePersistentIndexedCache<K, V> decorate(final String cacheId, String cacheName, final MultiProcessSafePersistentIndexedCache<K, V> original) {
        final Cache<Object, Object> data = this.loadData(cacheId, cacheName);
        return new MultiProcessSafePersistentIndexedCache<K, V>(){

            @Override
            public void close() {
                original.close();
            }

            @Override
            public V get(K key) {
                assert (key instanceof String || key instanceof Long || key instanceof File) : "Unsupported key type: " + key;
                Object value = data.getIfPresent(key);
                if (value == NULL) {
                    return null;
                }
                if (value != null) {
                    return value;
                }
                Object out = original.get(key);
                data.put(key, out == null ? NULL : out);
                return out;
            }

            @Override
            public void put(K key, V value) {
                original.put(key, value);
                data.put(key, value);
            }

            @Override
            public void remove(K key) {
                data.put(key, NULL);
                original.remove(key);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStartWork(String operationDisplayName, FileLock.State currentCacheState) {
                boolean outOfDate;
                Object object = InMemoryTaskArtifactCache.this.lock;
                synchronized (object) {
                    FileLock.State previousState = (FileLock.State)InMemoryTaskArtifactCache.this.states.get(cacheId);
                    outOfDate = previousState == null || currentCacheState.hasBeenUpdatedSince(previousState);
                }
                if (outOfDate) {
                    LOG.info("Invalidating in-memory cache of {}", cacheId);
                    data.invalidateAll();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onEndWork(FileLock.State currentCacheState) {
                Object object = InMemoryTaskArtifactCache.this.lock;
                synchronized (object) {
                    InMemoryTaskArtifactCache.this.states.put(cacheId, currentCacheState);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache<Object, Object> loadData(String cacheId, String cacheName) {
        Cache theData;
        Object object = this.lock;
        synchronized (object) {
            theData = (Cache)this.cache.getIfPresent((Object)cacheId);
            if (theData != null) {
                LOG.info("In-memory cache of {}: Size{{}}, {}", cacheId, theData.size(), theData.stats());
            } else {
                Integer maxSize = CACHE_CAPS.get(cacheName);
                assert (maxSize != null) : "Unknown cache.";
                LOG.info("Creating In-memory cache of {}: MaxSize{{}}", cacheId, maxSize);
                LoggingEvictionListener evictionListener = new LoggingEvictionListener(cacheId, maxSize);
                theData = CacheBuilder.newBuilder().maximumSize((long)maxSize.intValue()).recordStats().removalListener((RemovalListener)evictionListener).build();
                evictionListener.setCache((Cache<Object, Object>)theData);
                this.cache.put((Object)cacheId, (Object)theData);
            }
        }
        return theData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoggingEvictionListener
    implements RemovalListener<Object, Object> {
        private static Logger logger = Logging.getLogger(LoggingEvictionListener.class);
        private static final String EVICTION_MITIGATION_MESSAGE = "\nPerformance may suffer from in-memory cache misses. Increase max heap size of Gradle build process to reduce cache misses.";
        volatile int evictionCounter;
        private final String cacheId;
        private Cache<Object, Object> cache;
        private final int maxSize;
        private final int logInterval;

        private LoggingEvictionListener(String cacheId, int maxSize) {
            this.cacheId = cacheId;
            this.maxSize = maxSize;
            this.logInterval = maxSize / 10;
        }

        public void setCache(Cache<Object, Object> cache) {
            this.cache = cache;
        }

        public void onRemoval(RemovalNotification<Object, Object> notification) {
            if (notification.getCause() == RemovalCause.SIZE) {
                if (this.evictionCounter % this.logInterval == 0) {
                    logger.log(LogLevel.INFO, "Cache entries evicted. In-memory cache of {}: Size{{}} MaxSize{{}}, {} {}", this.cacheId, this.cache.size(), this.maxSize, this.cache.stats(), EVICTION_MITIGATION_MESSAGE);
                }
                ++this.evictionCounter;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CacheCapSizer {
        private static final Map<String, Integer> DEFAULT_CAP_SIZES = new HashMap<String, Integer>();
        final HeapProportionalSizer sizer;

        CacheCapSizer(int maxHeapMB) {
            this.sizer = maxHeapMB > 0 ? new HeapProportionalSizer(maxHeapMB) : new HeapProportionalSizer();
        }

        CacheCapSizer() {
            this(0);
        }

        public Map<String, Integer> calculateCaps() {
            HashMap<String, Integer> capSizes = new HashMap<String, Integer>();
            for (Map.Entry<String, Integer> entry : DEFAULT_CAP_SIZES.entrySet()) {
                capSizes.put(entry.getKey(), this.sizer.scaleValue(entry.getValue(), 100));
            }
            return capSizes;
        }

        static {
            DEFAULT_CAP_SIZES.put("fileSnapshots", 10000);
            DEFAULT_CAP_SIZES.put("taskArtifacts", 2000);
            DEFAULT_CAP_SIZES.put("outputFileStates", 3000);
            DEFAULT_CAP_SIZES.put("fileHashes", 400000);
            DEFAULT_CAP_SIZES.put("compilationState", 1000);
        }
    }
}

