/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Transformer;
import org.gradle.api.internal.tasks.testing.filter.TestSelectionMatcher;
import org.gradle.api.internal.tasks.testing.junit.CategoryFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestEventAdapter;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionListener;
import org.gradle.internal.concurrent.ThreadSafe;
import org.gradle.util.CollectionUtils;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitTestClassExecuter {
    private final ClassLoader applicationClassLoader;
    private final RunListener listener;
    private final JUnitSpec options;
    private final TestClassExecutionListener executionListener;

    public JUnitTestClassExecuter(ClassLoader applicationClassLoader, JUnitSpec spec, RunListener listener, TestClassExecutionListener executionListener) {
        assert (executionListener instanceof ThreadSafe);
        this.applicationClassLoader = applicationClassLoader;
        this.listener = listener;
        this.options = spec;
        this.executionListener = executionListener;
    }

    public void execute(String testClassName) {
        this.executionListener.testClassStarted(testClassName);
        Throwable failure = null;
        try {
            this.runTestClass(testClassName);
        }
        catch (Throwable throwable) {
            failure = throwable;
        }
        this.executionListener.testClassFinished(failure);
    }

    private void runTestClass(String testClassName) throws ClassNotFoundException {
        Request request;
        Runner runner;
        Class<?> testClass = Class.forName(testClassName, false, this.applicationClassLoader);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        if (this.options.hasCategoryConfiguration()) {
            Transformer transformer = new Transformer<Class<?>, String>(){

                public Class<?> transform(String original) {
                    try {
                        return JUnitTestClassExecuter.this.applicationClassLoader.loadClass(original);
                    }
                    catch (ClassNotFoundException e) {
                        throw new InvalidUserDataException(String.format("Can't load category class [%s].", original), (Throwable)e);
                    }
                }
            };
            filters.add(new CategoryFilter(CollectionUtils.collect(this.options.getIncludeCategories(), (Transformer)transformer), CollectionUtils.collect(this.options.getExcludeCategories(), (Transformer)transformer)));
        }
        if (!this.options.getIncludedTests().isEmpty()) {
            filters.add(new MethodNameFilter(this.options.getIncludedTests()));
        }
        if ((runner = (request = Request.aClass(testClass)).getRunner()) instanceof Filterable) {
            Filterable filterable = (Filterable)runner;
            for (Filter filter : filters) {
                try {
                    filterable.filter(filter);
                }
                catch (NoTestsRemainException e) {
                    return;
                }
            }
        } else if (this.allTestsFiltered(runner, filters)) {
            return;
        }
        RunNotifier notifier = new RunNotifier();
        notifier.addListener(this.listener);
        runner.run(notifier);
    }

    private boolean allTestsFiltered(Runner runner, List<Filter> filters) {
        LinkedList<Description> queue = new LinkedList<Description>();
        queue.add(runner.getDescription());
        while (!queue.isEmpty()) {
            Description description = (Description)queue.removeFirst();
            queue.addAll(description.getChildren());
            boolean run = true;
            for (Filter filter : filters) {
                if (filter.shouldRun(description)) continue;
                run = false;
                break;
            }
            if (!run) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodNameFilter
    extends Filter {
        private final TestSelectionMatcher matcher;

        public MethodNameFilter(Iterable<String> includedTests) {
            this.matcher = new TestSelectionMatcher(includedTests);
        }

        public boolean shouldRun(Description description) {
            return this.matcher.matchesTest(JUnitTestEventAdapter.className(description), JUnitTestEventAdapter.methodName(description));
        }

        public String describe() {
            return "Includes matching test methods";
        }
    }
}

