/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.report;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.tasks.testing.junit.report.AllTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.ClassPageRenderer;
import org.gradle.api.internal.tasks.testing.junit.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.OverviewPageRenderer;
import org.gradle.api.internal.tasks.testing.junit.report.PackagePageRenderer;
import org.gradle.api.internal.tasks.testing.junit.report.PackageTestResults;
import org.gradle.api.internal.tasks.testing.junit.report.TestReporter;
import org.gradle.api.internal.tasks.testing.junit.report.TestResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestFailure;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.reporting.HtmlReportBuilder;
import org.gradle.reporting.HtmlReportRenderer;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.Clock;

public class DefaultTestReport
implements TestReporter {
    private static final Logger LOG = Logging.getLogger(DefaultTestReport.class);

    public void generateReport(TestResultsProvider resultsProvider, File reportDir) {
        LOG.info("Generating HTML test report...");
        Clock clock = new Clock();
        AllTestResults model = this.loadModelFromProvider(resultsProvider);
        this.generateFiles(model, resultsProvider, reportDir);
        LOG.info("Finished generating test html results ({}) into: {}", (Object)clock.getTime(), (Object)reportDir);
    }

    private AllTestResults loadModelFromProvider(TestResultsProvider resultsProvider) {
        final AllTestResults model = new AllTestResults();
        resultsProvider.visitClasses((Action<? super TestClassResult>)new Action<TestClassResult>(){

            public void execute(TestClassResult classResult) {
                model.addTestClass(classResult.getId(), classResult.getClassName());
                List<TestMethodResult> collectedResults = classResult.getResults();
                for (TestMethodResult collectedResult : collectedResults) {
                    TestResult testResult = model.addTest(classResult.getId(), classResult.getClassName(), collectedResult.getName(), collectedResult.getDuration());
                    if (collectedResult.getResultType() == TestResult.ResultType.SKIPPED) {
                        testResult.setIgnored();
                        continue;
                    }
                    List<TestFailure> failures = collectedResult.getFailures();
                    for (TestFailure failure : failures) {
                        testResult.addFailure(failure);
                    }
                }
            }
        });
        return model;
    }

    private void generateFiles(AllTestResults model, final TestResultsProvider resultsProvider, File reportDir) {
        try {
            HtmlReportRenderer htmlRenderer = new HtmlReportRenderer();
            htmlRenderer.render((Object)model, (ReportRenderer)new ReportRenderer<AllTestResults, HtmlReportBuilder>(){

                public void render(AllTestResults model, HtmlReportBuilder output) throws IOException {
                    PackagePageRenderer packagePageRenderer = new PackagePageRenderer();
                    ClassPageRenderer classPageRenderer = new ClassPageRenderer(resultsProvider);
                    output.renderHtmlPage("index.html", (Object)model, (ReportRenderer)new OverviewPageRenderer());
                    for (PackageTestResults packageResults : model.getPackages()) {
                        output.renderHtmlPage(packageResults.getBaseUrl(), (Object)packageResults, (ReportRenderer)packagePageRenderer);
                        for (ClassTestResults classResults : packageResults.getClasses()) {
                            output.renderHtmlPage(classResults.getBaseUrl(), (Object)classResults, (ReportRenderer)classPageRenderer);
                        }
                    }
                }
            }, reportDir);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not generate test report to '%s'.", reportDir), (Throwable)e);
        }
    }
}

