/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.rhino.worker.internal;

import java.io.File;
import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.Factory;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerHandle;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerHandleFactory;
import org.gradle.plugins.javascript.rhino.worker.RhinoWorkerSpec;
import org.gradle.plugins.javascript.rhino.worker.internal.DefaultRhinoWorkerHandle;
import org.gradle.plugins.javascript.rhino.worker.internal.RhinoServer;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.WorkerProcess;
import org.gradle.process.internal.WorkerProcessBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRhinoWorkerHandleFactory
implements RhinoWorkerHandleFactory {
    private final Factory<WorkerProcessBuilder> workerProcessBuilderFactory;

    public DefaultRhinoWorkerHandleFactory(Factory<WorkerProcessBuilder> workerProcessBuilderFactory) {
        this.workerProcessBuilderFactory = workerProcessBuilderFactory;
    }

    @Override
    public <R extends Serializable, P extends Serializable> RhinoWorkerHandle<R, P> create(Iterable<File> rhinoClasspath, RhinoWorkerSpec<R, P> workerSpec, LogLevel logLevel, Action<JavaExecSpec> javaExecSpecAction) {
        WorkerProcessBuilder builder = (WorkerProcessBuilder)this.workerProcessBuilderFactory.create();
        builder.setBaseName("Gradle Rhino Worker");
        builder.setLogLevel(logLevel);
        builder.applicationClasspath(rhinoClasspath);
        builder.sharedPackages(new String[]{"org.mozilla.javascript"});
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        if (javaExecSpecAction != null) {
            javaExecSpecAction.execute((Object)javaCommand);
        }
        WorkerProcess workerProcess = builder.worker(new RhinoServer<R, P>(workerSpec)).build();
        return new DefaultRhinoWorkerHandle(workerSpec.getResultType(), workerProcess);
    }
}

