/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.tooling.internal.provider.ClassLoaderDetails;
import org.gradle.tooling.internal.provider.ClasspathInferer;
import org.gradle.tooling.internal.provider.DeserializeMap;
import org.gradle.tooling.internal.provider.PayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.SerializeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ClientSidePayloadClassLoaderRegistry
implements PayloadClassLoaderRegistry {
    private static final short CLIENT_CLASS_LOADER_ID = 1;
    private final PayloadClassLoaderRegistry delegate;
    private final Lock lock = new ReentrantLock();
    private final ClasspathInferer classpathInferer;
    private final Map<UUID, LocalClassLoader> classLoaders = new LinkedHashMap<UUID, LocalClassLoader>();

    public ClientSidePayloadClassLoaderRegistry(PayloadClassLoaderRegistry delegate, ClasspathInferer classpathInferer) {
        this.delegate = delegate;
        this.classpathInferer = classpathInferer;
    }

    @Override
    public SerializeMap newSerializeSession() {
        final LinkedHashSet candidates = new LinkedHashSet();
        final LinkedHashSet classPath = new LinkedHashSet();
        return new SerializeMap(){

            @Override
            public short visitClass(Class<?> target) {
                ClientSidePayloadClassLoaderRegistry.this.classpathInferer.getClassPathFor(target, classPath);
                candidates.add(target.getClassLoader());
                return 1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<Short, ClassLoaderDetails> getClassLoaders() {
                UUID uuid;
                ClientSidePayloadClassLoaderRegistry.this.lock.lock();
                try {
                    uuid = ClientSidePayloadClassLoaderRegistry.this.getUuid(candidates);
                }
                finally {
                    ClientSidePayloadClassLoaderRegistry.this.lock.unlock();
                }
                return Collections.singletonMap((short)1, new ClassLoaderDetails(uuid, new MutableURLClassLoader.Spec(new ArrayList<URL>(classPath))));
            }
        };
    }

    @Override
    public DeserializeMap newDeserializeSession() {
        final DeserializeMap deserializeMap = this.delegate.newDeserializeSession();
        return new DeserializeMap(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Class<?> resolveClass(ClassLoaderDetails classLoaderDetails, String className) throws ClassNotFoundException {
                Set candidates;
                ClientSidePayloadClassLoaderRegistry.this.lock.lock();
                try {
                    candidates = ClientSidePayloadClassLoaderRegistry.this.getClassLoaders(classLoaderDetails.uuid);
                }
                finally {
                    ClientSidePayloadClassLoaderRegistry.this.lock.unlock();
                }
                if (candidates != null) {
                    for (ClassLoader candidate : candidates) {
                        try {
                            return candidate.loadClass(className);
                        }
                        catch (ClassNotFoundException e) {
                        }
                    }
                    throw new UnsupportedOperationException("Unexpected class received in response.");
                }
                return deserializeMap.resolveClass(classLoaderDetails, className);
            }
        };
    }

    private Set<ClassLoader> getClassLoaders(UUID uuid) {
        LocalClassLoader localClassLoader = this.classLoaders.get(uuid);
        if (localClassLoader == null) {
            return null;
        }
        LinkedHashSet<ClassLoader> candidates = new LinkedHashSet<ClassLoader>();
        for (Reference reference : localClassLoader.classLoaders) {
            ClassLoader classLoader = (ClassLoader)reference.get();
            if (classLoader == null) continue;
            candidates.add(classLoader);
        }
        return candidates;
    }

    private UUID getUuid(Set<ClassLoader> candidates) {
        for (LocalClassLoader localClassLoader : new ArrayList<LocalClassLoader>(this.classLoaders.values())) {
            LinkedHashSet<ClassLoader> localCandidates = new LinkedHashSet<ClassLoader>();
            for (Reference reference : localClassLoader.classLoaders) {
                ClassLoader cl = (ClassLoader)reference.get();
                if (cl == null) continue;
                localCandidates.add(cl);
            }
            if (localCandidates.isEmpty()) {
                this.classLoaders.remove(localClassLoader.uuid);
                continue;
            }
            if (!localCandidates.equals(candidates)) continue;
            return localClassLoader.uuid;
        }
        LocalClassLoader details = new LocalClassLoader(UUID.randomUUID());
        for (ClassLoader candidate : candidates) {
            details.classLoaders.add(new WeakReference<ClassLoader>(candidate));
        }
        this.classLoaders.put(details.uuid, details);
        return details.uuid;
    }

    private static class LocalClassLoader {
        private final Set<Reference<ClassLoader>> classLoaders = new LinkedHashSet<Reference<ClassLoader>>();
        private final UUID uuid;

        private LocalClassLoader(UUID uuid) {
            this.uuid = uuid;
        }
    }
}

