/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.MessageIOException;
import org.gradle.messaging.remote.internal.MessageSerializer;
import org.gradle.messaging.remote.internal.inet.InetAddressFactory;
import org.gradle.messaging.remote.internal.inet.SocketInetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastConnection<T>
implements Connection<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MulticastConnection.class);
    private static final int MAX_MESSAGE_SIZE = 32768;
    private final MulticastSocket socket;
    private final SocketInetAddress address;
    private final MessageSerializer<T> serializer;
    private final SocketInetAddress localAddress;

    public MulticastConnection(SocketInetAddress address, MessageSerializer<T> serializer, InetAddressFactory addressFactory) {
        this.address = address;
        this.serializer = serializer;
        try {
            this.socket = new MulticastSocket(address.getPort());
            boolean bound = false;
            SocketException bindFailure = null;
            for (NetworkInterface networkInterface : addressFactory.findMulticastInterfaces()) {
                try {
                    this.socket.joinGroup(new InetSocketAddress(address.getAddress(), address.getPort()), networkInterface);
                    LOGGER.debug("Joined multicast address {} on network interface {}.", (Object)address, (Object)networkInterface.getDisplayName());
                    bound = true;
                }
                catch (SocketException e) {
                    LOGGER.debug("Failed to join multicast address {} on network interface {}.", (Object)address, (Object)networkInterface.getDisplayName());
                    if (bindFailure != null) continue;
                    bindFailure = e;
                }
            }
            if (!bound) {
                throw bindFailure;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Could not create multicast socket for %s", address.getDisplayName()), e);
        }
        this.localAddress = new SocketInetAddress(this.socket.getInetAddress(), this.socket.getLocalPort());
    }

    public String toString() {
        return String.format("multicast connection %s", this.address);
    }

    @Override
    public void dispatch(T message) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.serializer.newWriter(outputStream).write(message);
            outputStream.close();
            byte[] buffer = outputStream.toByteArray();
            this.socket.send(new DatagramPacket(buffer, buffer.length, this.address.getAddress(), this.address.getPort()));
        }
        catch (Exception e) {
            throw new MessageIOException(String.format("Could not write multi-cast message on %s.", this.address), e);
        }
    }

    @Override
    public T receive() {
        try {
            byte[] buffer = new byte[32768];
            DatagramPacket packet = new DatagramPacket(buffer, 0, buffer.length);
            this.socket.receive(packet);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(packet.getData(), packet.getOffset(), packet.getLength());
            return this.serializer.newReader(inputStream, this.localAddress, new SocketInetAddress(packet.getAddress(), packet.getPort())).read();
        }
        catch (SocketException e) {
            return null;
        }
        catch (Exception e) {
            throw new MessageIOException(String.format("Could not receive multi-cast message on %s", this.address), e);
        }
    }

    public void requestStop() {
        this.socket.close();
    }

    public void stop() {
        this.requestStop();
    }
}

