/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.jar;

import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.FilesSnapshotSet;
import org.gradle.api.internal.hash.Hasher;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.jar.DefaultJarSnapshotter;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarArchive;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshot;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.jar.JarSnapshotter;
import org.gradle.internal.Factory;

public class CachingJarSnapshotter
implements JarSnapshotter {
    private final DefaultJarSnapshotter snapshotter;
    private final Hasher hasher;
    private final JarSnapshotCache cache;
    private final FilesSnapshotSet inputFilesSnapshot;

    public CachingJarSnapshotter(Hasher hasher, ClassDependenciesAnalyzer analyzer, JarSnapshotCache cache, FilesSnapshotSet inputFilesSnapshot) {
        this.inputFilesSnapshot = inputFilesSnapshot;
        this.snapshotter = new DefaultJarSnapshotter(hasher, analyzer);
        this.hasher = hasher;
        this.cache = cache;
    }

    public JarSnapshot createSnapshot(final JarArchive jarArchive) {
        final byte[] hash = this.getHash(jarArchive);
        return (JarSnapshot)this.cache.get(hash, (Factory)new Factory<JarSnapshot>(){

            public JarSnapshot create() {
                return CachingJarSnapshotter.this.snapshotter.createSnapshot(hash, jarArchive);
            }
        });
    }

    private byte[] getHash(JarArchive jarArchive) {
        FileSnapshot s = this.inputFilesSnapshot.findSnapshot(jarArchive.file);
        if (s != null) {
            return s.getHash();
        }
        return this.hasher.hash(jarArchive.file);
    }
}

