/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.internal.toolchain;

import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonManager;
import org.gradle.language.scala.ScalaPlatform;
import org.gradle.language.scala.internal.toolchain.DefaultScalaToolProvider;
import org.gradle.language.scala.internal.toolchain.NotFoundScalaToolProvider;
import org.gradle.language.scala.internal.toolchain.ScalaToolChainInternal;
import org.gradle.platform.base.internal.toolchain.ToolProvider;

public class DownloadingScalaToolChain
implements ScalaToolChainInternal {
    private ProjectFinder projectFinder;
    private CompilerDaemonManager compilerDaemonManager;
    private final ConfigurationContainer configurationContainer;
    private final DependencyHandler dependencyHandler;
    private final JavaVersion javaVersion;

    public DownloadingScalaToolChain(ProjectFinder projectFinder, CompilerDaemonManager compilerDaemonManager, ConfigurationContainer configurationContainer, DependencyHandler dependencyHandler) {
        this.projectFinder = projectFinder;
        this.compilerDaemonManager = compilerDaemonManager;
        this.configurationContainer = configurationContainer;
        this.dependencyHandler = dependencyHandler;
        this.javaVersion = JavaVersion.current();
    }

    public String getName() {
        return String.format("Scala Toolchain", new Object[0]);
    }

    public String getDisplayName() {
        return String.format("Scala Toolchain (JDK %s (%s))", this.javaVersion.getMajorVersion(), this.javaVersion);
    }

    public ToolProvider select(ScalaPlatform targetPlatform) {
        try {
            Configuration scalaClasspath = this.resolveDependency(String.format("org.scala-lang:scala-compiler:%s", targetPlatform.getScalaVersion()));
            Configuration zincClasspath = this.resolveDependency(String.format("com.typesafe.zinc:zinc:%s", "0.3.7"));
            Set resolvedScalaClasspath = scalaClasspath.resolve();
            Set resolvedZincClasspath = zincClasspath.resolve();
            return new DefaultScalaToolProvider(this.projectFinder, this.compilerDaemonManager, resolvedScalaClasspath, resolvedZincClasspath);
        }
        catch (ResolveException resolveException) {
            return new NotFoundScalaToolProvider((Exception)((Object)resolveException));
        }
    }

    private Configuration resolveDependency(Object dependencyNotation) {
        Dependency dependency = this.dependencyHandler.create(dependencyNotation);
        return this.configurationContainer.detachedConfiguration(new Dependency[]{dependency});
    }
}

