/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencyResolveDetails;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitution;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.ModuleSelectorStringNotationConverter;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.UnversionedModuleComponentSelector;
import org.gradle.internal.Actions;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependencySubstitutions
implements DependencySubstitutionsInternal {
    private final Set<Action<? super DependencySubstitution>> substitutionRules;
    private final NotationParser<Object, ComponentSelector> moduleSelectorNotationParser;
    private final NotationParser<Object, ComponentSelector> projectSelectorNotationParser;
    private MutationValidator mutationValidator = MutationValidator.IGNORE;
    private boolean hasDependencySubstitutionRule;

    public DefaultDependencySubstitutions() {
        this(new LinkedHashSet<Action<? super DependencySubstitution>>());
    }

    DefaultDependencySubstitutions(Set<Action<? super DependencySubstitution>> substitutionRules) {
        this.substitutionRules = substitutionRules;
        this.moduleSelectorNotationParser = DefaultDependencySubstitutions.createModuleSelectorNotationParser();
        this.projectSelectorNotationParser = DefaultDependencySubstitutions.createProjectSelectorNotationParser();
    }

    @Override
    public boolean hasDependencySubstitutionRules() {
        return this.hasDependencySubstitutionRule;
    }

    @Override
    public Action<DependencySubstitution> getDependencySubstitutionRule() {
        return Actions.composite(this.substitutionRules);
    }

    private void addRule(Action<? super DependencySubstitution> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.substitutionRules.add(rule);
    }

    public DependencySubstitutions all(Action<? super DependencySubstitution> rule) {
        this.addRule(rule);
        this.hasDependencySubstitutionRule = true;
        return this;
    }

    @Override
    public DependencySubstitutions allWithDependencyResolveDetails(Action<? super DependencyResolveDetails> rule) {
        this.addRule(new DependencyResolveDetailsWrapperAction(rule));
        return this;
    }

    public ComponentSelector module(String notation) {
        return (ComponentSelector)this.moduleSelectorNotationParser.parseNotation((Object)notation);
    }

    public ComponentSelector project(String path) {
        return (ComponentSelector)this.projectSelectorNotationParser.parseNotation((Object)path);
    }

    public DependencySubstitutions.Substitution substitute(final ComponentSelector substituted) {
        return new DependencySubstitutions.Substitution(){

            public void with(ComponentSelector substitute) {
                DefaultDependencySubstitution.validateTarget(substitute);
                if (substituted instanceof UnversionedModuleComponentSelector) {
                    ModuleIdentifier moduleId = ((UnversionedModuleComponentSelector)substituted).getModuleIdentifier();
                    DefaultDependencySubstitutions.this.all(new ModuleMatchDependencySubstitutionAction(moduleId, substitute));
                } else {
                    DefaultDependencySubstitutions.this.all(new ExactMatchDependencySubstitutionAction(substituted, substitute));
                }
            }
        };
    }

    @Override
    public void setMutationValidator(MutationValidator validator) {
        this.mutationValidator = validator;
    }

    @Override
    public DependencySubstitutionsInternal copy() {
        return new DefaultDependencySubstitutions(new LinkedHashSet<Action<? super DependencySubstitution>>(this.substitutionRules));
    }

    private static NotationParser<Object, ComponentSelector> createModuleSelectorNotationParser() {
        return NotationParserBuilder.toType(ComponentSelector.class).converter((NotationConverter)new ModuleSelectorStringNotationConverter()).toComposite();
    }

    private static NotationParser<Object, ComponentSelector> createProjectSelectorNotationParser() {
        return NotationParserBuilder.toType(ComponentSelector.class).fromCharSequence((NotationConverter)new ProjectPathConverter()).toComposite();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DependencyResolveDetailsWrapperAction
    implements Action<DependencySubstitution> {
        private final Action<? super DependencyResolveDetails> delegate;

        public DependencyResolveDetailsWrapperAction(Action<? super DependencyResolveDetails> delegate) {
            this.delegate = delegate;
        }

        public void execute(DependencySubstitution substitution) {
            DefaultDependencyResolveDetails details = new DefaultDependencyResolveDetails((DependencySubstitutionInternal)substitution);
            this.delegate.execute((Object)details);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModuleMatchDependencySubstitutionAction
    implements Action<DependencySubstitution> {
        private final ModuleIdentifier moduleId;
        private final ComponentSelector substitute;

        public ModuleMatchDependencySubstitutionAction(ModuleIdentifier moduleId, ComponentSelector substitute) {
            this.moduleId = moduleId;
            this.substitute = substitute;
        }

        public void execute(DependencySubstitution dependencySubstitution) {
            if (dependencySubstitution.getRequested() instanceof ModuleComponentSelector) {
                ModuleComponentSelector requested = (ModuleComponentSelector)dependencySubstitution.getRequested();
                if (this.moduleId.getGroup().equals(requested.getGroup()) && this.moduleId.getName().equals(requested.getModule())) {
                    dependencySubstitution.useTarget((Object)this.substitute);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ExactMatchDependencySubstitutionAction
    implements Action<DependencySubstitution> {
        private final ComponentSelector substituted;
        private final ComponentSelector substitute;

        public ExactMatchDependencySubstitutionAction(ComponentSelector substituted, ComponentSelector substitute) {
            this.substituted = substituted;
            this.substitute = substitute;
        }

        public void execute(DependencySubstitution dependencySubstitution) {
            if (this.substituted.equals(dependencySubstitution.getRequested())) {
                dependencySubstitution.useTarget((Object)this.substitute);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProjectPathConverter
    implements NotationConverter<String, ProjectComponentSelector> {
        private ProjectPathConverter() {
        }

        public void describe(DiagnosticsVisitor visitor) {
            visitor.example("Project paths, e.g. ':api'.");
        }

        public void convert(String notation, NotationConvertResult<? super ProjectComponentSelector> result) throws TypeConversionException {
            result.converted((Object)DefaultProjectComponentSelector.newSelector(notation));
        }
    }
}

