/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.internal;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.jvm.JarBinarySpec;
import org.gradle.jvm.toolchain.JavaToolChain;
import org.gradle.jvm.toolchain.JavaToolChainRegistry;
import org.gradle.language.base.internal.BuildDirHolder;
import org.gradle.model.Defaults;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.ComponentSpec;

public class JarBinaryRules
extends RuleSource {
    @Defaults
    void configureJarBinaries(ComponentSpec jvmLibrary, BuildDirHolder buildDirHolder, final JavaToolChainRegistry toolChains) {
        final File binariesDir = new File(buildDirHolder.getDir(), "jars");
        final File classesDir = new File(buildDirHolder.getDir(), "classes");
        jvmLibrary.getBinaries().withType(JarBinarySpec.class).beforeEach((Action)new Action<JarBinarySpec>(){

            public void execute(JarBinarySpec jarBinary) {
                String jarBinaryName = jarBinary.getName();
                int idx = jarBinaryName.lastIndexOf("Jar");
                String apiJarBinaryName = idx > 0 ? jarBinaryName.substring(0, idx) + "ApiJar" : jarBinaryName + "ApiJar";
                String libraryName = jarBinary.getId().getLibraryName();
                File outputDir = new File(classesDir, jarBinaryName);
                jarBinary.setClassesDir(outputDir);
                jarBinary.setResourcesDir(outputDir);
                jarBinary.setJarFile(new File(binariesDir, String.format("%s%s%s.jar", jarBinaryName, File.separator, libraryName)));
                jarBinary.setApiJarFile(new File(binariesDir, String.format("%s%s%s.jar", apiJarBinaryName, File.separator, libraryName)));
                jarBinary.setToolChain((JavaToolChain)toolChains.getForPlatform(jarBinary.getTargetPlatform()));
            }
        });
    }
}

