/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.Dimension;
import java.awt.Point;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class AtkComponent {
    AccessibleContext ac;
    AccessibleComponent acc_component;

    public AtkComponent(AccessibleContext accessibleContext) {
        this.ac = accessibleContext;
        this.acc_component = accessibleContext.getAccessibleComponent();
    }

    public boolean contains(int n, int n2, int n3) {
        if (n3 == 0) {
            Point point = this.acc_component.getLocationOnScreen();
            n -= point.x;
            n2 -= point.y;
        }
        return this.acc_component.contains(new Point(n, n2));
    }

    public AccessibleContext get_accessible_at_point(int n, int n2, int n3) {
        Object object;
        if (n3 == 0) {
            object = this.acc_component.getLocationOnScreen();
            n -= ((Point)object).x;
            n2 -= ((Point)object).y;
        }
        if ((object = this.acc_component.getAccessibleAt(new Point(n, n2))) == null) {
            return null;
        }
        return object.getAccessibleContext();
    }

    public Point get_position(int n) {
        if (n == 0) {
            return this.acc_component.getLocationOnScreen();
        }
        return this.acc_component.getLocation();
    }

    public Dimension get_size() {
        return this.acc_component.getSize();
    }

    public boolean grab_focus() {
        if (!this.acc_component.isFocusTraversable()) {
            return false;
        }
        this.acc_component.requestFocus();
        return true;
    }

    public int get_layer() {
        AccessibleRole accessibleRole = this.ac.getAccessibleRole();
        if (accessibleRole == AccessibleRole.MENU || accessibleRole == AccessibleRole.MENU_ITEM || accessibleRole == AccessibleRole.POPUP_MENU) {
            return 5;
        }
        if (accessibleRole == AccessibleRole.INTERNAL_FRAME) {
            return 4;
        }
        if (accessibleRole == AccessibleRole.GLASS_PANE) {
            return 6;
        }
        if (accessibleRole == AccessibleRole.CANVAS || accessibleRole == AccessibleRole.ROOT_PANE || accessibleRole == AccessibleRole.LAYERED_PANE) {
            return 2;
        }
        return 3;
    }
}

