/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

public class PropertiesCellRenderer
extends DefaultTableCellRenderer {
    private void setColors(Component component, String string, boolean bl) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        if (OsmPrimitive.getDiscardableKeys().contains(string)) {
            if (bl) {
                component.setForeground(Main.pref.getColor(I18n.marktr("Discardable key: selection Foreground"), Color.GRAY));
                component.setBackground(Main.pref.getColor(I18n.marktr("Discardable key: selection Background"), uIDefaults.getColor("Table.selectionBackground")));
            } else {
                component.setForeground(Main.pref.getColor(I18n.marktr("Discardable key: foreground"), Color.GRAY));
                component.setBackground(Main.pref.getColor(I18n.marktr("Discardable key: background"), uIDefaults.getColor("Table.background")));
            }
        } else {
            component.setForeground(uIDefaults.getColor("Table." + (bl ? "selectionF" : "f") + "oreground"));
            component.setBackground(uIDefaults.getColor("Table." + (bl ? "selectionB" : "b") + "ackground"));
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Component component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        if (object == null) {
            return this;
        }
        if (component instanceof JLabel) {
            Object object2;
            Object object3;
            String string = null;
            if (object instanceof String) {
                string = (String)object;
            } else if (object instanceof Map) {
                object3 = (Map)object;
                if (object3.size() != 1) {
                    Integer n3;
                    if (object3.get("") == null) {
                        object2 = 0;
                        n3 = object3.size();
                    } else {
                        object2 = (Integer)object3.get("");
                        n3 = object3.size() - 1;
                    }
                    StringBuilder stringBuilder = new StringBuilder("<");
                    if (n3 == 1) {
                        for (Map.Entry entry : object3.entrySet()) {
                            if (Objects.equals(entry.getKey(), "")) continue;
                            stringBuilder.append(I18n.tr("{0} ''{1}''", entry.getValue().toString(), entry.getKey()));
                        }
                    } else {
                        stringBuilder.append(I18n.trn("{0} different", "{0} different", n3.intValue(), n3));
                    }
                    if ((Integer)object2 > 0) {
                        stringBuilder.append(I18n.trn(", {0} unset", ", {0} unset", ((Integer)object2).intValue(), object2));
                    }
                    stringBuilder.append('>');
                    string = stringBuilder.toString();
                    component.setFont(component.getFont().deriveFont(2));
                } else {
                    object2 = object3.entrySet().iterator().next();
                    string = (String)object2.getKey();
                }
            }
            ((JLabel)component).putClientProperty("html.disable", Boolean.TRUE);
            ((JLabel)component).setText(string);
            if (Main.pref.getBoolean("display.discardable-keys", false)) {
                object3 = null;
                if (n2 == 0) {
                    object3 = string;
                } else if (n2 == 1 && (object2 = jTable.getModel().getValueAt(n, 0)) instanceof String) {
                    object3 = (String)object2;
                }
                this.setColors(component, (String)object3, bl);
            }
        }
        return component;
    }
}

