/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.notes.NoteComment;
import org.openstreetmap.josm.data.osm.NoteData;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.dialogs.NotesDialog;
import org.openstreetmap.josm.gui.io.AbstractIOTask;
import org.openstreetmap.josm.gui.io.UploadNoteLayerTask;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.NoteExporter;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;

public class NoteLayer
extends AbstractModifiableLayer
implements MouseListener {
    private final NoteData noteData;

    public NoteLayer(Collection<Note> collection, String string) {
        super(string);
        this.noteData = new NoteData(collection);
    }

    public NoteLayer() {
        this(Collections.emptySet(), I18n.tr("Notes", new Object[0]));
    }

    @Override
    public void hookUpMapView() {
        Main.map.mapView.addMouseListener(this);
    }

    public NoteData getNoteData() {
        return this.noteData;
    }

    @Override
    public boolean isModified() {
        return this.noteData.isModified();
    }

    @Override
    public boolean requiresUploadToServer() {
        return this.isModified();
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public boolean requiresSaveToFile() {
        return this.getAssociatedFile() != null && this.isModified();
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        Object object;
        for (Note object3 : this.noteData.getNotes()) {
            Point point = mapView.getPoint(object3.getLatLon());
            object = null;
            object = object3.getId() < 0L ? NotesDialog.ICON_NEW_SMALL : (object3.getState() == Note.State.closed ? NotesDialog.ICON_CLOSED_SMALL : NotesDialog.ICON_OPEN_SMALL);
            int n = ((ImageIcon)object).getIconWidth();
            int n2 = ((ImageIcon)object).getIconHeight();
            graphics2D.drawImage(((ImageIcon)object).getImage(), point.x - n / 2, point.y - n2, Main.map.mapView);
        }
        if (this.noteData.getSelectedNote() != null) {
            StringBuilder stringBuilder = new StringBuilder("<html>");
            stringBuilder.append(I18n.tr("Note", new Object[0])).append(' ').append(this.noteData.getSelectedNote().getId());
            for (NoteComment noteComment : this.noteData.getSelectedNote().getComments()) {
                object = noteComment.getText();
                if (object == null || ((String)object).trim().isEmpty()) continue;
                stringBuilder.append("<hr/>");
                String string = XmlWriter.encode(noteComment.getUser().getName());
                if (string == null || string.trim().isEmpty()) {
                    string = "&lt;Anonymous&gt;";
                }
                stringBuilder.append(string);
                stringBuilder.append(" on ");
                stringBuilder.append(DateUtils.getDateFormat(2).format(noteComment.getCommentTimestamp()));
                stringBuilder.append(":<br/>");
                String string2 = XmlWriter.encode(noteComment.getText(), true);
                string2 = string2.replace("&#xA;", "<br/>");
                string2 = string2.replace("/", "/\u200b");
                stringBuilder.append(string2);
            }
            stringBuilder.append("</html>");
            JToolTip jToolTip = new JToolTip();
            jToolTip.setTipText(stringBuilder.toString());
            Point point = mapView.getPoint(this.noteData.getSelectedNote().getLatLon());
            graphics2D.setColor(ColorHelper.html2color(Main.pref.get("color.selected")));
            graphics2D.drawRect(point.x - 8, point.y - 16, 15, 15);
            int n = point.x + 8 + 5;
            int n3 = point.y - 16 - 1;
            graphics2D.translate(n, n3);
            for (int i = 0; i < 2; ++i) {
                Dimension dimension = jToolTip.getUI().getPreferredSize(jToolTip);
                dimension.width = Math.min(dimension.width, mapView.getWidth() / 2);
                if (dimension.width <= 0 || dimension.height <= 0) continue;
                jToolTip.setSize(dimension);
                try {
                    jToolTip.paint(graphics2D);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Main.error(illegalArgumentException, false);
                }
            }
            graphics2D.translate(-n, -n3);
        }
    }

    @Override
    public Icon getIcon() {
        return NotesDialog.ICON_OPEN_SMALL;
    }

    @Override
    public String getToolTipText() {
        return this.noteData.getNotes().size() + 32 + I18n.tr("Notes", new Object[0]);
    }

    @Override
    public void mergeFrom(Layer layer) {
        throw new UnsupportedOperationException("Notes layer does not support merging yet");
    }

    @Override
    public boolean isMergable(Layer layer) {
        return false;
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (Note note : this.noteData.getNotes()) {
            boundingXYVisitor.visit(note.getLatLon());
        }
    }

    @Override
    public Object getInfoComponent() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(I18n.tr("Notes layer", new Object[0])).append('\n').append(I18n.tr("Total notes:", new Object[0])).append(' ').append(this.noteData.getNotes().size()).append('\n').append(I18n.tr("Changes need uploading?", new Object[0])).append(' ').append(this.isModified());
        return stringBuilder.toString();
    }

    @Override
    public Action[] getMenuEntries() {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        arrayList.add(LayerListDialog.getInstance().createShowHideLayerAction());
        arrayList.add(LayerListDialog.getInstance().createDeleteLayerAction());
        arrayList.add(new LayerListPopup.InfoAction(this));
        arrayList.add(new Layer.LayerSaveAction(this));
        arrayList.add(new Layer.LayerSaveAsAction(this));
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent) && this.noteData.getSelectedNote() != null) {
            String string = OsmApi.getOsmApi().getBaseUrl() + "notes/" + this.noteData.getSelectedNote().getId();
            Utils.copyToClipboard(string);
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        Point point = mouseEvent.getPoint();
        double d = 10.0;
        double d2 = Double.MAX_VALUE;
        Note note = null;
        for (Note note2 : this.noteData.getNotes()) {
            Point point2 = Main.map.mapView.getPoint(note2.getLatLon());
            point2.setLocation(point2.getX(), point2.getY() - 8.0);
            double d3 = point.distanceSq(point2);
            if (!(d2 > d3) || !(point.distance(point2) < d)) continue;
            d2 = d3;
            note = note2;
        }
        this.noteData.setSelectedNote(note);
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save GPX file", new Object[0]), NoteExporter.FILE_FILTER);
    }

    @Override
    public AbstractIOTask createUploadTask(ProgressMonitor progressMonitor) {
        return new UploadNoteLayerTask(this, progressMonitor);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

