/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.instrument;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.Instrument;
import com.oracle.truffle.api.instrument.InstrumentationNode;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.SyntaxTagTrap;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;

@NodeInfo(cost=NodeCost.NONE)
public final class ProbeNode
extends Node
implements InstrumentationNode.TruffleEvents,
InstrumentationNode {
    @CompilerDirectives.CompilationFinal
    Probe probe = null;
    @Node.Child
    protected Instrument.AbstractInstrumentNode firstInstrumentNode;

    public static Probe insertProbe(WrapperNode wrapper) {
        SourceSection sourceSection = wrapper.getChild().getSourceSection();
        ProbeNode probeNode = new ProbeNode();
        probeNode.probe = new Probe(probeNode, sourceSection);
        wrapper.insertProbe(probeNode);
        return probeNode.probe;
    }

    @Override
    public boolean isInstrumentable() {
        return false;
    }

    @Override
    public Node copy() {
        Node node = super.copy();
        this.probe.registerProbeNodeClone((ProbeNode)node);
        return node;
    }

    public Probe getProbe() {
        return this.probe;
    }

    @Override
    public void enter(Node node, VirtualFrame vFrame) {
        this.probe.checkProbeUnchanged();
        SyntaxTagTrap beforeTagTrap = this.probe.getBeforeTrap();
        if (beforeTagTrap != null) {
            beforeTagTrap.tagTrappedAt(((WrapperNode)((Object)this.getParent())).getChild(), vFrame.materialize());
        }
        if (this.firstInstrumentNode != null) {
            this.firstInstrumentNode.enter(node, vFrame);
        }
    }

    @Override
    public void returnVoid(Node node, VirtualFrame vFrame) {
        SyntaxTagTrap afterTagTrap;
        this.probe.checkProbeUnchanged();
        if (this.firstInstrumentNode != null) {
            this.firstInstrumentNode.returnVoid(node, vFrame);
        }
        if ((afterTagTrap = this.probe.getAfterTrap()) != null) {
            afterTagTrap.tagTrappedAt(((WrapperNode)((Object)this.getParent())).getChild(), vFrame.materialize());
        }
    }

    @Override
    public void returnValue(Node node, VirtualFrame vFrame, Object result) {
        SyntaxTagTrap afterTagTrap;
        this.probe.checkProbeUnchanged();
        if (this.firstInstrumentNode != null) {
            this.firstInstrumentNode.returnValue(node, vFrame, result);
        }
        if ((afterTagTrap = this.probe.getAfterTrap()) != null) {
            afterTagTrap.tagTrappedAt(((WrapperNode)((Object)this.getParent())).getChild(), vFrame.materialize());
        }
    }

    @Override
    public void returnExceptional(Node node, VirtualFrame vFrame, Exception exception) {
        SyntaxTagTrap afterTagTrap;
        this.probe.checkProbeUnchanged();
        if (this.firstInstrumentNode != null) {
            this.firstInstrumentNode.returnExceptional(node, vFrame, exception);
        }
        if ((afterTagTrap = this.probe.getAfterTrap()) != null) {
            afterTagTrap.tagTrappedAt(((WrapperNode)((Object)this.getParent())).getChild(), vFrame.materialize());
        }
    }

    @Override
    public String instrumentationInfo() {
        return "Standard probe";
    }

    @CompilerDirectives.TruffleBoundary
    void addInstrument(Instrument instrument) {
        assert (instrument.getProbe() == this.probe);
        this.firstInstrumentNode = this.insert(instrument.addToChain(this.firstInstrumentNode));
    }

    @CompilerDirectives.TruffleBoundary
    void removeInstrument(Instrument instrument) {
        assert (instrument.getProbe() == this.probe);
        Instrument.AbstractInstrumentNode modifiedChain = instrument.removeFromChain(this.firstInstrumentNode);
        this.firstInstrumentNode = modifiedChain == null ? null : this.insert(modifiedChain);
    }

    public static interface WrapperNode
    extends InstrumentationNode {
        public Node getChild();

        public Probe getProbe();

        public void insertProbe(ProbeNode var1);
    }
}

