/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes.serial;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import com.oracle.truffle.api.nodes.serial.SerializerConstantPool;
import com.oracle.truffle.api.nodes.serial.UnsupportedConstantPoolTypeException;
import com.oracle.truffle.api.nodes.serial.VariableLengthIntBuffer;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

public final class PostOrderSerializer {
    private static final Unsafe unsafe = PostOrderSerializer.loadUnsafe();
    private final SerializerConstantPool cp;

    public PostOrderSerializer(SerializerConstantPool cp) {
        this.cp = cp;
    }

    public byte[] serialize(Node node) throws UnsupportedConstantPoolTypeException {
        VariableLengthIntBuffer buffer = new VariableLengthIntBuffer(ByteBuffer.allocate(512));
        this.serialize(buffer, node);
        return buffer.getBytes();
    }

    private void serialize(VariableLengthIntBuffer buffer, Node node) throws UnsupportedConstantPoolTypeException {
        if (node == null) {
            buffer.put(-1);
            return;
        }
        Class<?> nodeClass = node.getClass();
        NodeFieldAccessor[] nodeFields = NodeClass.get(nodeClass).getFields();
        this.serializeChildFields(buffer, node, nodeFields);
        this.serializeChildrenFields(buffer, node, nodeFields);
        buffer.put(this.cp.putClass(node.getClass()));
        this.serializeDataFields(buffer, node, nodeFields);
    }

    private void serializeDataFields(VariableLengthIntBuffer buffer, Node node, NodeFieldAccessor[] nodeFields) throws UnsupportedConstantPoolTypeException {
        int i = 0;
        while (i < nodeFields.length) {
            NodeFieldAccessor field = nodeFields[i];
            if (field.getKind() == NodeFieldAccessor.NodeFieldKind.DATA) {
                Class<?> fieldClass = field.getType();
                long offset = field.getOffset();
                if (!field.getType().isAssignableFrom(SourceSection.class)) {
                    int cpi = fieldClass == Integer.TYPE ? this.cp.putInt(unsafe.getInt(node, offset)) : (fieldClass == Long.TYPE ? this.cp.putLong(unsafe.getLong(node, offset)) : (fieldClass == Float.TYPE ? this.cp.putFloat(unsafe.getFloat(node, offset)) : (fieldClass == Double.TYPE ? this.cp.putDouble(unsafe.getDouble(node, offset)) : (fieldClass == Byte.TYPE ? this.cp.putInt(unsafe.getByte(node, offset)) : (fieldClass == Short.TYPE ? this.cp.putInt(unsafe.getShort(node, offset)) : (fieldClass == Character.TYPE ? this.cp.putInt(unsafe.getChar(node, offset)) : (fieldClass == Boolean.TYPE ? this.cp.putInt(unsafe.getBoolean(node, offset) ? 1 : 0) : this.serializeDataFieldsObject(node, fieldClass, offset))))))));
                    buffer.put(cpi);
                }
            }
            ++i;
        }
    }

    private int serializeDataFieldsObject(Node node, Class<?> fieldClass, long offset) {
        Object value = unsafe.getObject(node, offset);
        if (value == null) {
            return -1;
        }
        if (fieldClass == Integer.class) {
            return this.cp.putInt((Integer)value);
        }
        if (fieldClass == Long.class) {
            return this.cp.putLong((Long)value);
        }
        if (fieldClass == Float.class) {
            return this.cp.putFloat(((Float)value).floatValue());
        }
        if (fieldClass == Double.class) {
            return this.cp.putDouble((Double)value);
        }
        if (fieldClass == Byte.class) {
            return this.cp.putInt(((Byte)value).byteValue());
        }
        if (fieldClass == Short.class) {
            return this.cp.putInt(((Short)value).shortValue());
        }
        if (fieldClass == Character.class) {
            return this.cp.putInt(((Character)value).charValue());
        }
        if (fieldClass == Boolean.class) {
            return this.cp.putInt((Boolean)value != false ? 1 : 0);
        }
        return this.cp.putObject(fieldClass, value);
    }

    private void serializeChildrenFields(VariableLengthIntBuffer buffer, Node nodeInstance, NodeFieldAccessor[] nodeFields) throws UnsupportedConstantPoolTypeException {
        int i = 0;
        while (i < nodeFields.length) {
            NodeFieldAccessor field = nodeFields[i];
            if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN) {
                Object childArrayObject = unsafe.getObject(nodeInstance, field.getOffset());
                if (childArrayObject != null && !(childArrayObject instanceof Node[])) {
                    throw new AssertionError((Object)"Node children must be instanceof Node[]");
                }
                buffer.put(this.cp.putClass(field.getType()));
                Node[] childArray = (Node[])childArrayObject;
                if (childArray == null) {
                    buffer.put(-1);
                } else {
                    buffer.put(this.cp.putInt(childArray.length));
                    int j = 0;
                    while (j < childArray.length) {
                        this.serialize(buffer, childArray[j]);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private void serializeChildFields(VariableLengthIntBuffer buffer, Node nodeInstance, NodeFieldAccessor[] nodeFields) throws UnsupportedConstantPoolTypeException {
        int i = 0;
        while (i < nodeFields.length) {
            NodeFieldAccessor field = nodeFields[i];
            if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD) {
                Object childObject = unsafe.getObject(nodeInstance, field.getOffset());
                if (childObject != null && !(childObject instanceof Node)) {
                    throw new AssertionError((Object)"Node children must be instanceof Node");
                }
                this.serialize(buffer, (Node)childObject);
            }
            ++i;
        }
    }

    private static Unsafe loadUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }
}

