/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.constants;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.constants.ReadConstantNode;
import org.jruby.truffle.nodes.literal.LiteralNode;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

public class ReadLiteralConstantNode
extends RubyNode {
    @Node.Child
    private ReadConstantNode readConstantNode;

    public ReadLiteralConstantNode(RubyContext context, SourceSection sourceSection, RubyNode moduleNode, String name) {
        super(context, sourceSection);
        LiteralNode nameNode = new LiteralNode(context, sourceSection, name);
        this.readConstantNode = new ReadConstantNode(context, sourceSection, false, false, moduleNode, nameNode);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.readConstantNode.execute(frame);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        RubyConstant constant;
        Object module;
        RubyContext context = this.getContext();
        String name = (String)this.readConstantNode.nameNode.execute(frame);
        try {
            module = this.readConstantNode.moduleNode.execute(frame);
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getRubyException()) == context.getCoreLibrary().getNameErrorClass()) {
                return this.nil();
            }
            throw e;
        }
        if (!RubyGuards.isRubyModule(module)) {
            return this.nil();
        }
        try {
            constant = this.readConstantNode.lookupConstantNode.executeLookupConstant(frame, module, name);
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getRubyException()) == context.getCoreLibrary().getNameErrorClass()) {
                return this.nil();
            }
            throw e;
        }
        if (constant == null) {
            return this.nil();
        }
        return this.create7BitString(StringOperations.encodeByteList("constant", (Encoding)UTF8Encoding.INSTANCE));
    }
}

