/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;

public class StringCodeRangeableWrapper
implements CodeRangeable {
    private final DynamicObject string;

    public StringCodeRangeableWrapper(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        this.string = string;
    }

    public int getCodeRange() {
        return Layouts.STRING.getCodeRange(this.string);
    }

    public int scanForCodeRange() {
        return StringOperations.scanForCodeRange(this.string);
    }

    public boolean isCodeRangeValid() {
        return StringOperations.isCodeRangeValid(this.string);
    }

    public final void setCodeRange(int newCodeRange) {
        Layouts.STRING.setCodeRange(this.string, newCodeRange);
    }

    public final void clearCodeRange() {
        StringOperations.clearCodeRange(this.string);
    }

    public final void keepCodeRange() {
        StringOperations.keepCodeRange(this.string);
    }

    public final void modify() {
        StringOperations.modify(this.string);
    }

    public final void modify(int length) {
        StringOperations.modify(this.string, length);
    }

    public final void modifyAndKeepCodeRange() {
        StringOperations.modifyAndKeepCodeRange(this.string);
    }

    public Encoding checkEncoding(CodeRangeable other) {
        return StringOperations.checkEncoding(this.string, other);
    }

    public ByteList getByteList() {
        return StringOperations.getByteList(this.string);
    }
}

