/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;

public abstract class MethodHandleUtils {
    public static MethodHandle getPrivateGetter(Class<?> klass, String fieldName) {
        Field field = MethodHandleUtils.getPrivateField(klass, fieldName);
        try {
            return MethodHandles.lookup().unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static MethodHandle getPrivateSetter(Class<?> klass, String fieldName) {
        Field field = MethodHandleUtils.getPrivateField(klass, fieldName);
        try {
            return MethodHandles.lookup().unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getPrivateField(Class<?> klass, String fieldName) {
        try {
            Field field = klass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }
}

