/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging;

import java.io.IOException;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.tagging.CombiningTagger;
import org.languagetool.tagging.ManualTagger;
import org.languagetool.tagging.TaggedWord;
import org.languagetool.tagging.WordTagger;

public class CombiningTaggerTest {
    @Test
    public void testTagNoOverwrite() throws Exception {
        CombiningTagger tagger = this.getCombiningTagger(false);
        Assert.assertThat((Object)tagger.tag("nosuchword").size(), (Matcher)CoreMatchers.is((Object)0));
        List result = tagger.tag("fullform");
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)2));
        String asString = this.getAsString(result);
        Assert.assertTrue((boolean)asString.contains("baseform1/POSTAG1"));
        Assert.assertTrue((boolean)asString.contains("baseform2/POSTAG2"));
    }

    @Test
    public void testTagOverwrite() throws Exception {
        CombiningTagger tagger = this.getCombiningTagger(true);
        Assert.assertThat((Object)tagger.tag("nosuchword").size(), (Matcher)CoreMatchers.is((Object)0));
        List result = tagger.tag("fullform");
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.is((Object)1));
        String asString = this.getAsString(result);
        Assert.assertTrue((boolean)asString.contains("baseform2/POSTAG2"));
    }

    private CombiningTagger getCombiningTagger(boolean overwrite) throws IOException {
        ManualTagger tagger1 = new ManualTagger(JLanguageTool.getDataBroker().getFromResourceDirAsStream("/xx/added1.txt"));
        ManualTagger tagger2 = new ManualTagger(JLanguageTool.getDataBroker().getFromResourceDirAsStream("/xx/added2.txt"));
        return new CombiningTagger((WordTagger)tagger1, (WordTagger)tagger2, overwrite);
    }

    private String getAsString(List<TaggedWord> result) {
        StringBuilder sb = new StringBuilder();
        for (TaggedWord taggedWord : result) {
            sb.append(taggedWord.getLemma());
            sb.append("/");
            sb.append(taggedWord.getPosTag());
            sb.append("\n");
        }
        return sb.toString();
    }

    @Test(expected=IOException.class)
    public void testInvalidFile() throws Exception {
        new ManualTagger(JLanguageTool.getDataBroker().getFromResourceDirAsStream("/xx/added-invalid.txt"));
    }
}

