var Node = require("./node"),
    getDebugInfo = require("./debug-info");

var Comment = function (value, isLineComment, index, currentFileInfo) {
    this.value = value;
    this.isLineComment = isLineComment;
    this.currentFileInfo = currentFileInfo;
};
Comment.prototype = new Node();
Comment.prototype.type = "Comment";
Comment.prototype.genCSS = function (context, output) {
    if (this.debugInfo) {
        output.add(getDebugInfo(context, this), this.currentFileInfo, this.index);
    }
    output.add(this.value);
};
Comment.prototype.isSilent = function(context) {
    var isReference = (this.currentFileInfo && this.currentFileInfo.reference && !this.isReferenced),
        isCompressed = context.compress && this.value[2] !== "!";
    return this.isLineComment || isReference || isCompressed;
};
Comment.prototype.markReferenced = function () {
    this.isReferenced = true;
};
module.exports = Comment;
