# -*- coding: utf-8 -*-

# LyricsScreenlet Copyright (C) 2009 by Marcel Dancak <dancakm@gmail.com>

#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


import urllib2
import hashlib
from xml.dom.minidom import parse, parseString


class MiniLyricsEngine:
	continueDownloading = True
	
	def __init__(self, callback):
		self.resultCallback = callback
		
	def stop(self):
		self.continueDownloading = False
		
	def find(self, songInfo):
		self.continueDownloading = True
		if not songInfo.has_key('title') or not songInfo.has_key('artist'):
			return
		
		title  = songInfo['title' ]
		artist = songInfo['artist']
		
		xml ="<?xml version=\"1.0\" encoding='utf-8'?>\r\n"
		xml+="<search filetype=\"lyrics\" artist=\"%s\" title=\"%s\" " % (artist.encode('utf-8'), title.encode('utf-8'))
		xml+="ClientCharEncoding=\"utf-8\"/>\r\n"
		md5hash=hashlib.md5(xml+"Mlv1clt4.0").digest()
		request="\x02\x00\x04\x00\x00\x00%s%s" % (md5hash, xml)
		del md5hash,xml
	
		url="http://www.viewlyrics.com:1212/searchlyrics.htm"
		#print request
		req=urllib2.Request(url,request)
		req.add_header("User-Agent", "MiniLyrics")
		print "minilyrics"
		self.lyricsCount = 0
		try:
			response = urllib2.urlopen(url, request)
			xml = response.read()
			response.close()

			dom = parseString(xml)

			elements = dom.getElementsByTagName('fileinfo')
			
			for element in elements:
				if self.continueDownloading == False:
					break
				
				artistAttribute = element.getAttribute('artist').lower()
				#print "%s in: %s" % (artist, artistAttribute)
				#print element.getAttribute('link')
				#print artistAttribute.lower().find(artist.lower())
				if artistAttribute.lower().find(artist.lower()) != -1:
					url = element.getAttribute('link')
					#print url
					response = urllib2.urlopen(url)
					lyrics = response.read()#.encode('utf-8')
					#print "URL: %s" % url
					#print lyrics
					if self.continueDownloading == True:
						self.resultCallback(lyrics)
						self.lyricsCount += 1
					response.close()
		except Exception, e:
			print e
		print "Minilyrics Lyrics Count: %d" % self.lyricsCount
