/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import org.elasticsearch.common.Priority;

public abstract class PrioritizedRunnable
implements Runnable,
Comparable<PrioritizedRunnable> {
    private final Priority priority;
    private final long creationDate;

    public static PrioritizedRunnable wrap(Runnable runnable, Priority priority) {
        return new Wrapped(runnable, priority);
    }

    protected PrioritizedRunnable(Priority priority) {
        this.priority = priority;
        this.creationDate = System.nanoTime();
    }

    public long getCreationDateInNanos() {
        return this.creationDate;
    }

    public long getAgeInMillis() {
        return Math.max(0L, (System.nanoTime() - this.creationDate) / 1000L);
    }

    @Override
    public int compareTo(PrioritizedRunnable pr) {
        return this.priority.compareTo(pr.priority);
    }

    public Priority priority() {
        return this.priority;
    }

    static class Wrapped
    extends PrioritizedRunnable {
        private final Runnable runnable;

        private Wrapped(Runnable runnable, Priority priority) {
            super(priority);
            this.runnable = runnable;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }
}

