/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.MergeResult;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.EnabledAttributeMapper;
import org.elasticsearch.index.query.QueryParseContext;

public class IndexFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_index";
    public static final String CONTENT_TYPE = "_index";
    private EnabledAttributeMapper enabledState;

    private IndexFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing == null ? Defaults.FIELD_TYPE.clone() : existing, Defaults.ENABLED_STATE, indexSettings);
    }

    private IndexFieldMapper(MappedFieldType fieldType, EnabledAttributeMapper enabledState, Settings indexSettings) {
        super("_index", fieldType, Defaults.FIELD_TYPE, indexSettings);
        this.enabledState = enabledState;
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    public String value(Document document) {
        Field field = (Field)document.getField(this.fieldType().names().indexName());
        return field == null ? null : (String)this.fieldType().value(field);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (!this.enabledState.enabled) {
            return;
        }
        fields.add(new Field(this.fieldType().names().indexName(), context.index(), (FieldType)this.fieldType()));
    }

    @Override
    protected String contentType() {
        return "_index";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.fieldType().stored() == Defaults.FIELD_TYPE.stored() && this.enabledState == Defaults.ENABLED_STATE && !this.hasCustomFieldDataSettings()) {
            return builder;
        }
        builder.startObject("_index");
        if (this.indexCreatedBefore2x && (includeDefaults || this.fieldType().stored() != Defaults.FIELD_TYPE.stored())) {
            builder.field("store", this.fieldType().stored());
        }
        if (includeDefaults || this.enabledState != Defaults.ENABLED_STATE) {
            builder.field("enabled", this.enabledState.enabled);
        }
        if (this.indexCreatedBefore2x && (includeDefaults || this.hasCustomFieldDataSettings())) {
            builder.field("fielddata", this.fieldType().fieldDataType().getSettings().getAsMap());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeResult mergeResult) throws MergeMappingException {
        IndexFieldMapper indexFieldMapperMergeWith = (IndexFieldMapper)mergeWith;
        if (!mergeResult.simulate() && indexFieldMapperMergeWith.enabledState != this.enabledState && !indexFieldMapperMergeWith.enabledState.unset()) {
            this.enabledState = indexFieldMapperMergeWith.enabledState;
        }
    }

    static final class IndexFieldType
    extends MappedFieldType {
        public IndexFieldType() {
        }

        protected IndexFieldType(IndexFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new IndexFieldType(this);
        }

        @Override
        public String typeName() {
            return "_index";
        }

        @Override
        public boolean useTermQueryWithQueryString() {
            return true;
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryParseContext context) {
            if (context == null) {
                return super.termQuery(value, context);
            }
            if (this.isSameIndex(value, context.index().getName())) {
                return Queries.newMatchAllQuery();
            }
            return Queries.newMatchNoDocsQuery();
        }

        @Override
        public Query termsQuery(List values, QueryParseContext context) {
            if (context == null) {
                return super.termsQuery(values, context);
            }
            for (Object value : values) {
                if (!this.isSameIndex(value, context.index().getName())) continue;
                return Queries.newMatchAllQuery();
            }
            return Queries.newMatchNoDocsQuery();
        }

        private boolean isSameIndex(Object value, String indexName) {
            if (value instanceof BytesRef) {
                BytesRef indexNameRef = new BytesRef((CharSequence)indexName);
                return indexNameRef.bytesEquals((BytesRef)value);
            }
            return indexName.equals(value.toString());
        }

        @Override
        public String value(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(parserContext.mapperService().fullName("_index"));
            if (parserContext.indexVersionCreated().onOrAfter(Version.V_2_0_0_beta1)) {
                return builder;
            }
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("enabled")) continue;
                EnabledAttributeMapper mapper = XContentMapValues.nodeBooleanValue(fieldNode) ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED;
                builder.enabled(mapper);
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(Settings indexSettings, MappedFieldType fieldType, String typeName) {
            return new IndexFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, IndexFieldMapper> {
        private EnabledAttributeMapper enabledState = EnabledAttributeMapper.UNSET_DISABLED;

        public Builder(MappedFieldType existing) {
            super("_index", existing == null ? Defaults.FIELD_TYPE : existing);
            this.indexName = "_index";
        }

        public Builder enabled(EnabledAttributeMapper enabledState) {
            this.enabledState = enabledState;
            return this;
        }

        @Override
        public IndexFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            this.fieldType.setHasDocValues(false);
            return new IndexFieldMapper(this.fieldType, this.enabledState, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_index";
        public static final MappedFieldType FIELD_TYPE = new IndexFieldType();
        public static final EnabledAttributeMapper ENABLED_STATE;

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setNames(new MappedFieldType.Names("_index"));
            FIELD_TYPE.freeze();
            ENABLED_STATE = EnabledAttributeMapper.UNSET_DISABLED;
        }
    }
}

