/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.valuecount;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.valuecount.InternalValueCount;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class ValueCountAggregator
extends NumericMetricsAggregator.SingleValue {
    final ValuesSource valuesSource;
    final ValueFormatter formatter;
    LongArray counts;

    public ValueCountAggregator(String name, ValuesSource valuesSource, ValueFormatter formatter, AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, aggregationContext, parent, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        if (valuesSource != null) {
            this.counts = this.context.bigArrays().newLongArray(1L, true);
        }
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BigArrays bigArrays = this.context.bigArrays();
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                ValueCountAggregator.this.counts = bigArrays.grow(ValueCountAggregator.this.counts, bucket + 1L);
                values.setDocument(doc);
                ValueCountAggregator.this.counts.increment(bucket, values.count());
            }
        };
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.valuesSource == null ? 0.0 : (double)this.counts.get(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.counts.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalValueCount(this.name, this.counts.get(bucket), this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalValueCount(this.name, 0L, this.formatter, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.counts);
    }

    public static class Factory<VS extends ValuesSource>
    extends ValuesSourceAggregatorFactory.LeafOnly<VS> {
        public Factory(String name, ValuesSourceConfig<VS> config) {
            super(name, InternalValueCount.TYPE.name(), config);
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new ValueCountAggregator(this.name, null, this.config.formatter(), aggregationContext, parent, pipelineAggregators, metaData);
        }

        @Override
        protected Aggregator doCreateInternal(VS valuesSource, AggregationContext aggregationContext, Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
            return new ValueCountAggregator(this.name, (ValuesSource)valuesSource, this.config.formatter(), aggregationContext, parent, pipelineAggregators, metaData);
        }
    }
}

