/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline.bucketmetrics.max;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorFactory;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregatorStreams;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.BucketMetricsPipelineAggregator;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.InternalBucketMetricValue;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class MaxBucketPipelineAggregator
extends BucketMetricsPipelineAggregator {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("max_bucket");
    public static final PipelineAggregatorStreams.Stream STREAM = new PipelineAggregatorStreams.Stream(){

        @Override
        public MaxBucketPipelineAggregator readResult(StreamInput in) throws IOException {
            MaxBucketPipelineAggregator result = new MaxBucketPipelineAggregator();
            result.readFrom(in);
            return result;
        }
    };
    private List<String> maxBucketKeys;
    private double maxValue;

    public static void registerStreams() {
        PipelineAggregatorStreams.registerStream(STREAM, TYPE.stream());
    }

    private MaxBucketPipelineAggregator() {
    }

    protected MaxBucketPipelineAggregator(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, ValueFormatter formatter, Map<String, Object> metaData) {
        super(name, bucketsPaths, gapPolicy, formatter, metaData);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    protected void preCollection() {
        this.maxBucketKeys = new ArrayList<String>();
        this.maxValue = Double.NEGATIVE_INFINITY;
    }

    @Override
    protected void collectBucketValue(String bucketKey, Double bucketValue) {
        if (bucketValue > this.maxValue) {
            this.maxBucketKeys.clear();
            this.maxBucketKeys.add(bucketKey);
            this.maxValue = bucketValue;
        } else if (bucketValue.equals(this.maxValue)) {
            this.maxBucketKeys.add(bucketKey);
        }
    }

    @Override
    protected InternalAggregation buildAggregation(List<PipelineAggregator> pipelineAggregators, Map<String, Object> metadata) {
        String[] keys = this.maxBucketKeys.toArray(new String[this.maxBucketKeys.size()]);
        return new InternalBucketMetricValue(this.name(), keys, this.maxValue, this.formatter, Collections.EMPTY_LIST, this.metaData());
    }

    public static class Factory
    extends PipelineAggregatorFactory {
        private final ValueFormatter formatter;
        private final BucketHelpers.GapPolicy gapPolicy;

        public Factory(String name, String[] bucketsPaths, BucketHelpers.GapPolicy gapPolicy, ValueFormatter formatter) {
            super(name, TYPE.name(), bucketsPaths);
            this.gapPolicy = gapPolicy;
            this.formatter = formatter;
        }

        @Override
        protected PipelineAggregator createInternal(Map<String, Object> metaData) throws IOException {
            return new MaxBucketPipelineAggregator(this.name, this.bucketsPaths, this.gapPolicy, this.formatter, metaData);
        }

        @Override
        public void doValidate(AggregatorFactory parent, AggregatorFactory[] aggFactories, List<PipelineAggregatorFactory> pipelineAggregatorFactories) {
            if (this.bucketsPaths.length != 1) {
                throw new IllegalStateException(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName() + " must contain a single entry for aggregation [" + this.name + "]");
            }
        }
    }
}

