raismth.ns(function() { with (raismth.LIB) {
myDump("[RAISMTH] player module initialization\n");

theApp.myObserver = {
        init : function(idx) {
		this.idx = idx;
                this.register();
        }
}
theApp.myObserver.prototype = {	
        observe: function(subject, topic, data) {
                let process = subject.QueryInterface(Ci.nsIProcess);
                if(process.exitValue == 0 || topic == "process-finished") {
			if(raismth) raismth.player.shutdown(this.idx);
                }
                this.unregister();
        },

        register: function() {
                myDump('[RAISMTH] Registering player-observer-component\n');
                let observerService = Cc["@mozilla.org/observer-service;1"]
                        .getService(Ci.nsIObserverService);
                observerService.addObserver(this, "myTopicID", false);
        },

        unregister: function() {
                myDump('[RAISMTH] Un-registering player-observer-component\n');
                let observerService = Cc["@mozilla.org/observer-service;1"]
                        .getService(Ci.nsIObserverService);
                observerService.removeObserver(this, "myTopicID");
        },
}

theApp.player = {
	pref : function(player, id, uri, smooth, vc1, isRadio, a) {
		let obj = raismth.slobj[id];
		let params = new Array();
		let mplayer = false;		       
		if(smooth) mplayer = true;
		if(player.indexOf('mplayer') != -1 && player.indexOf('wmplayer') == -1) mplayer = true;
		if(mplayer) {
			params.push('-really-quiet');
			if(raismth.sep == "/") { //linux only
				params.push('-stop-xscreensaver');
				params.push('-idx');
				if(raismth.mplayer_fifo && smooth) {
					params.push('-slave');
					params.push('-input');
					params.push('file=/tmp/mplayer-fifo-' + id);
				}
			}			
                        // params.push ('-af');
                        // params.push ('volnorm');
			params.push('-nokeepaspect');
			params.push('-noconsolecontrols');			

			if(raismth.player_aspect) {
				params.push('-aspect');
				params.push(raismth.player_aspect);
			}

			if(raismth.x11) {
				params.push('-zoom');
				params.push('-vo');
				params.push('x11');
			}

			if(raismth.fs) {
				params.push('-fs');
			}

			if(raismth.wintop) {
				params.push('-ontop');
			}

			if(smooth) {
				// params.push('-autosync');
				// params.push('60');
				params.push('-mc');
				params.push('0');
				params.push('-delay');
				params.push(obj.avshift);
				let vext = vc1[0];
				let aext = vc1[1];
				if(vext === '.vc1'){
					params.push('-vc');
					params.push('ffvc1');
				} 
				if(raismth.wmadmo && vext === '.vc1') {
                                        params.push('-ac');
					params.push('wmadmo');
				}
				params.push('-audiofile');
				params.push(raismth.temp_folder.path + raismth.sep + uri + aext);
                                if(raismth.mplayer_faad) {
                                        myDump('[KOW]\n\n\n***************\n\n\n');
                                        params.push('-audio-demuxer');
                                        params.push('rawaudio');
                                        params.push('-rawaudio');
                                        params.push('rate=' + a[2] + ':bitrate=' + a[1] + ':format=0xff');
                                }
				params.push(raismth.temp_folder.path + raismth.sep + uri + vext);
			} else {
				// params.push('-nocache');
				if(!isRadio) {
					params.push('-cache');
					params.push('512');
					params.push('-cache-min');
					params.push('30');
				}	
				if(uri.indexOf('wmv') != -1) uri = uri.replace('http', 'mms');
				params.push(uri);
			}
		} else {
			// other players options here
			params.push(uri);
		}
		return params;
	},

	prefs : function(idx, player_path) {
		let slobj = raismth.slobj[idx];
		let smooth = slobj.isSmooth;
		let uri = smooth ? slobj.temp_file : slobj.videoURI;
		let params = new Array();
		let mplayer = false;
		if((player_path.indexOf('mplayer') != -1 && player_path.indexOf('wmplayer') == -1 )|| smooth) mplayer = true;
		if(mplayer) {
			if(!raismth.debug) params.push('-quiet');
			if(!raismth.debug) params.push('-really-quiet');
			params.push('-stop-xscreensaver');			
			params.push('-idx');
			// if(raismth.mplayer_fifo) {
				// alert('using fifo');
				params.push('-slave');
				params.push('-input');
				params.push('file=/tmp/mplayer-fifo-' + idx);
			// }
			params.push('-nokeepaspect');
			params.push('-noconsolecontrols');
			if(raismth.player_aspect) {
				params.push('-aspect');
				params.push(raismth.player_aspect);
			}
			if(raismth.x11) {
                                params.push('-zoom');
                                params.push('-vo');
                                params.push('x11');
                        }

                        if(raismth.fs) {
                                params.push('-fs');
                        }

                        if(raismth.wintop) {
                                params.push('-ontop');
                        }
			if(smooth) {
				params.push('-fps');
				params.push('25');
				// kow fix
				if(raismth.forks) {
					// params.push('-fps');
					// params.push('25');
					params.push('-nocorrect-pts');
				}
				//
				params.push('-autosync');
				params.push('30');
				params.push('-mc');
                                params.push('0');
                                params.push('-delay');
                                params.push(slobj.avshift);
                                let v_ext = slobj.myStream.v_ext;
                                let a_ext = slobj.myStream.a_ext;
                                if(v_ext === '.vc1'){
                                        params.push('-vc');
                                        params.push('ffvc1');
                                }
                                if(raismth.wmadmo && v_ext === '.vc1') {
                                        params.push('-ac');
                                        params.push('wmadmo');
                                }
                                params.push('-audiofile');
                                params.push(raismth.temp_folder.path + raismth.sep + uri + a_ext);
                                if(raismth.mplayer_faad) {
                                        myDump('[KOW]\n\n\n***************\n\n\n');
		                        let tgt = slobj.media.Clip[slobj.clip];
					
		                        let a = (2 * slobj.clip) + 1;
					let aql_sel = slobj.myStream.aql_sel;
		                        let Bitrate = tgt.StreamIndex[tgt.def_audio_idx].QualityLevel[slobj.aqli].Bitrate;
		                        let SamplingRate = tgt.StreamIndex[tgt.def_audio_idx].QualityLevel[slobj.aqli].SamplingRate;
                                        params.push('-audio-demuxer');
                                        params.push('rawaudio');
                                        params.push('-rawaudio');
                                        params.push('rate=' + SamplingRate + ':bitrate=' + Bitrate + ':format=0xff');
                                }
                                params.push(raismth.temp_folder.path + raismth.sep + uri + v_ext);
			} else {
				// fixme
				let isRadio = false;
				if(!isRadio) {
                                        params.push('-cache');
                                        params.push('512');
                                        params.push('-cache-min');
                                        params.push('30');
                                }
                                if(uri.indexOf('wmv') != -1) uri = uri.replace('http', 'mms');
                                params.push(uri);
			}
		} else {
			// other players options here
			params.push(uri);
		}
		return params;
	},

	load : function (idx) {
		let slobj = raismth.slobj[idx];
		let smooth = slobj.isSmooth;
		let url = slobj.videoUrl;
		let uri = slobj.videoURI;
		let retvalue = null;
		let nsILocalFile = Cc["@mozilla.org/file/local;1"].createInstance(Ci.nsILocalFile);

		let nsIProcess = Cc["@mozilla.org/process/util;1"].createInstance(Ci.nsIProcess);
		let Prefs = Cc["@mozilla.org/preferences-service;1"].getService(Ci.nsIPrefBranch);
		let player_path = smooth ? Prefs.getCharPref("extensions.raismth.smth-player-path") : Prefs.getCharPref("extensions.raismth.mmsh-player-path");
		try {
			nsILocalFile.initWithPath(player_path);
		} catch (e) {
			alert('Incorrect player path [' + (smooth?'SMTH':'MMS') + ']');
		} finally {
			if(nsILocalFile.exists()){
				let paramArray = raismth.player.prefs(idx, player_path);
				slobj.stato('PL->LOAD', 'index:'+idx+' path:'+player_path, 1);
				myDump('[RAISMTH] paramArray : ' + paramArray.toString() + "\n");
				nsIProcess.init(nsILocalFile);
				let observer = raismth.myObserver;
				observer.init(idx);
				nsIProcess.runAsync(paramArray, paramArray.length, observer);
				retvalue = nsIProcess;
			} else {
				retvalue = false;
			}
		}
		return retvalue;	
		// alert(url + ' ' + uri);
		// return true;
	},

	shutdown : function(idx) {
		if(raismth.slobj[idx]) {
			let o = raismth.slobj[idx];
			o.stato('PL->QUIT', 'index:'+idx+' ts:'+raismth.rai_windows_ts[idx], 1, 9);
			o.kill = true;
			if(o.grabber_timer) o.grabber_timer.cancel();
			o.busy = false;
			o.playing = false;
			o.offset = 0;
			if(o.isSmooth) raismth.utils.clean_temp(o.temp_file);
			if(raismth.playall && !o.media.IsLive && o.clip < o.media.Clip.length-1) {
                                o.clip++;
                                o.stato('UI->GRAB', 'Loading next clip', 1, 9);
                                o.loader = Cc["@mozilla.org/timer;1"].createInstance(Ci.nsITimer);
                                let obj = raismth.slobj[idx];
                                if(obj) o.loader.initWithCallback(function() { obj.switch_action(obj.clip, true, true, idx); }, 2000, Ci.nsITimer.TYPE_ONE_SHOT);
                        }
		}
	},			   

};

theApp.myObserver.__proto__ = theApp.myObserver.prototype;

}});
