/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.MarketData;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TransactionListener;

public class MarketWas {
    private static final Logger logger = Logger.getLogger(MarketWas.class.getName());
    private final Market market;
    private final int tax;
    private final Map<GoodsType, Integer> costToBuy = new HashMap<GoodsType, Integer>();
    private final Map<GoodsType, Integer> paidForSale = new HashMap<GoodsType, Integer>();

    public MarketWas(Player player) {
        this.market = player.getMarket();
        this.tax = player.getTax();
        for (MarketData md : this.market.getMarketData()) {
            this.costToBuy.put(md.getGoodsType(), md.getCostToBuy());
            this.paidForSale.put(md.getGoodsType(), md.getPaidForSale());
        }
    }

    public void fireChanges(List<AbstractGoods> req) {
        for (AbstractGoods ag : req) {
            this.fireChanges(ag.getType(), ag.getAmount());
        }
    }

    public void fireChanges(GoodsType type, int amount) {
        for (TransactionListener l : this.market.getTransactionListener()) {
            if (amount > 0) {
                int buy = this.costToBuy.containsKey(type) ? this.costToBuy.get(type).intValue() : this.market.getCostToBuy(type);
                l.logPurchase(type, amount, buy);
                continue;
            }
            if (amount >= 0) continue;
            int sell = this.paidForSale.containsKey(type) ? this.paidForSale.get(type).intValue() : this.market.getPaidForSale(type);
            l.logSale(type, -amount, sell, this.tax);
        }
    }
}

