/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.shtm;

import com.lightdev.app.shtm.DialogShell;
import com.lightdev.app.shtm.DocumentPane;
import com.lightdev.app.shtm.SHTMLEditorPane;
import com.lightdev.app.shtm.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Highlighter;
import javax.swing.text.html.HTML;

class AnchorDialog
extends DialogShell
implements ActionListener,
CaretListener,
ListSelectionListener,
DocumentListener {
    private JList anchorList;
    private JButton addAnchor;
    private JButton delAnchor;
    private SHTMLEditorPane editor;
    private DocumentPane dp;
    private Document doc = null;
    private URL url = null;
    private final Hashtable anchorTable = new Hashtable();
    private boolean needsSaving = true;
    private static final String helpTopicId = "item165";

    public AnchorDialog(Dialog parent, String title, Document doc) {
        super(parent, title, helpTopicId);
        this.initDialog(doc, null);
    }

    public AnchorDialog(Frame parent, String title, Document doc) {
        super(parent, title, helpTopicId);
        this.initDialog(doc, null);
    }

    public AnchorDialog(Dialog parent, String title, URL url) {
        super(parent, title, helpTopicId);
        this.initDialog(null, url);
    }

    public AnchorDialog(Frame parent, String title, URL url) {
        super(parent, title, helpTopicId);
        this.initDialog(null, url);
    }

    private void initDialog(Document doc, URL url) {
        this.url = url;
        JPanel anchorPanel = new JPanel(new BorderLayout());
        anchorPanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("anchorPanelLabel")));
        this.anchorList = new JList();
        anchorPanel.add((Component)new JScrollPane(this.anchorList), "Center");
        this.anchorList.addListSelectionListener(this);
        this.addAnchor = new JButton(Util.getResourceString("addImgBtnTitle"));
        this.addAnchor.addActionListener(this);
        this.delAnchor = new JButton(Util.getResourceString("delImgBtnTitle"));
        this.delAnchor.addActionListener(this);
        JPanel helpPanel = new JPanel();
        helpPanel.add(this.addAnchor);
        helpPanel.add(this.delAnchor);
        anchorPanel.add((Component)helpPanel, "South");
        if (doc != null) {
            this.needsSaving = false;
            this.dp = new DocumentPane();
            doc.addDocumentListener(this);
            this.dp.setDocument(doc);
            this.doc = doc;
        } else {
            this.needsSaving = true;
            this.dp = new DocumentPane(url, 1);
            this.doc = this.dp.getDocument();
        }
        this.editor = this.dp.getEditor();
        this.editor.setEditable(false);
        this.editor.addCaretListener(this);
        JPanel docPanel = new JPanel(new BorderLayout());
        docPanel.setBorder(new TitledBorder(new EtchedBorder(1), Util.getResourceString("docPanelLabel")));
        docPanel.add((Component)this.editor, "Center");
        helpPanel = new JPanel(new BorderLayout());
        helpPanel.add((Component)anchorPanel, "West");
        helpPanel.add((Component)docPanel, "Center");
        Container contentPane = super.getContentPane();
        ((JComponent)contentPane).setPreferredSize(new Dimension(600, 500));
        contentPane.add((Component)helpPanel, "Center");
        this.pack();
        this.updateAnchorList();
        this.addAnchor.setEnabled(false);
        this.delAnchor.setEnabled(false);
    }

    public void dispose() {
        this.editor.removeCaretListener(this);
        this.doc.removeDocumentListener(this);
        super.dispose();
    }

    private void updateAnchorList() {
        this.getAnchors(this.doc);
        this.anchorList.setListData(this.anchorTable.keySet().toArray());
    }

    private void getAnchors(Document doc) {
        HTML.Tag.A.toString();
        this.anchorTable.clear();
        ElementIterator eli = new ElementIterator(doc);
        Element elem = eli.first();
        while (elem != null) {
            Object nameAttr;
            Object link = elem.getAttributes().getAttribute(HTML.Tag.A);
            if (link != null && (nameAttr = ((AttributeSet)link).getAttribute(HTML.Attribute.NAME)) != null) {
                this.anchorTable.put(nameAttr, elem);
            }
            elem = eli.next();
        }
    }

    private void doAddAnchor() {
        String anchorName = Util.nameInput(null, "", ".*", "addAnchorTitle", "addAnchorText");
        if (anchorName != null) {
            this.editor.insertAnchor(anchorName);
            this.saveChanges();
            this.updateAnchorList();
        }
    }

    private void saveChanges() {
        if (this.needsSaving && this.url != null) {
            try {
                this.dp.saveDocument();
            }
            catch (Exception e) {
                Util.errMsg(this, e.getMessage(), e);
            }
        }
    }

    public String getAnchor() {
        String anchorName = null;
        if (this.anchorList.getSelectedIndex() > -1) {
            anchorName = this.anchorList.getSelectedValue().toString();
        }
        return anchorName;
    }

    private void doDelAnchor() {
        String anchorName = this.anchorList.getSelectedValue().toString();
        this.dp.getEditor().removeAnchor(anchorName);
        this.saveChanges();
        this.updateAnchorList();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.addAnchor)) {
            this.doAddAnchor();
        } else if (src.equals(this.delAnchor)) {
            this.doDelAnchor();
        } else {
            super.actionPerformed(e);
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.anchorList)) {
            Highlighter h = this.editor.getHighlighter();
            DefaultHighlighter.DefaultHighlightPainter p = new DefaultHighlighter.DefaultHighlightPainter(Color.yellow);
            Object o = this.anchorList.getSelectedValue();
            if (o != null) {
                Element elem = (Element)this.anchorTable.get(this.anchorList.getSelectedValue());
                int start = elem.getStartOffset();
                int end = elem.getEndOffset();
                try {
                    if (end == start) {
                        end = start + 3;
                    }
                    this.editor.select(start, end);
                    h.removeAllHighlights();
                    h.addHighlight(start, end, p);
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
        }
    }

    public void caretUpdate(CaretEvent e) {
        Object src = e.getSource();
        if (src.equals(this.editor)) {
            this.addAnchor.setEnabled(this.editor.getSelectionStart() != this.editor.getSelectionEnd());
            this.delAnchor.setEnabled(this.anchorList.getSelectedIndex() > -1);
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.updateAnchorList();
    }

    public void removeUpdate(DocumentEvent e) {
        this.updateAnchorList();
    }

    public void changedUpdate(DocumentEvent e) {
        this.updateAnchorList();
    }
}

