/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.forge.jlatexmath.Glue;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GlueSettingsParser {
    private static final String RESOURCE_NAME = "GlueSettings.xml";
    private final Map<String, Integer> typeMappings = new HashMap<String, Integer>();
    private final Map<String, Integer> glueTypeMappings = new HashMap<String, Integer>();
    private Glue[] glueTypes;
    private final Map<String, Integer> styleMappings = new HashMap<String, Integer>();
    private Element root;

    public GlueSettingsParser() throws ResourceParseException {
        try {
            this.setTypeMappings();
            this.setStyleMappings();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setIgnoringComments(true);
            this.root = documentBuilderFactory.newDocumentBuilder().parse(GlueSettingsParser.class.getResourceAsStream(RESOURCE_NAME)).getDocumentElement();
            this.parseGlueTypes();
        }
        catch (Exception exception) {
            throw new XMLResourceParseException(RESOURCE_NAME, exception);
        }
    }

    private void setStyleMappings() {
        this.styleMappings.put("display", 0);
        this.styleMappings.put("text", 1);
        this.styleMappings.put("script", 2);
        this.styleMappings.put("script_script", 3);
    }

    private void parseGlueTypes() throws ResourceParseException {
        Object object;
        ArrayList<Glue> arrayList = new ArrayList<Glue>();
        Element element = (Element)this.root.getElementsByTagName("GlueTypes").item(0);
        int n = -1;
        int n2 = 0;
        if (element != null) {
            object = element.getElementsByTagName("GlueType");
            for (int i = 0; i < object.getLength(); ++i) {
                Element element2 = (Element)object.item(i);
                String string = GlueSettingsParser.getAttrValueAndCheckIfNotNull("name", element2);
                Glue glue = this.createGlue(element2, string);
                if (string.equalsIgnoreCase("default")) {
                    n = n2;
                }
                arrayList.add(glue);
                ++n2;
            }
        }
        if (n < 0) {
            n = n2;
            arrayList.add(new Glue(0.0f, 0.0f, 0.0f, "default"));
        }
        this.glueTypes = arrayList.toArray(new Glue[arrayList.size()]);
        if (n > 0) {
            object = this.glueTypes[n];
            this.glueTypes[n] = this.glueTypes[0];
            this.glueTypes[0] = object;
        }
        for (int i = 0; i < this.glueTypes.length; ++i) {
            this.glueTypeMappings.put(this.glueTypes[i].getName(), i);
        }
    }

    private Glue createGlue(Element element, String string) throws ResourceParseException {
        String[] stringArray = new String[]{"space", "stretch", "shrink"};
        float[] fArray = new float[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            double d = 0.0;
            String string2 = null;
            try {
                string2 = element.getAttribute(stringArray[i]);
                if (!string2.equals("")) {
                    d = Double.parseDouble(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new XMLResourceParseException(RESOURCE_NAME, "GlueType", stringArray[i], "has an invalid real value '" + string2 + "'!");
            }
            fArray[i] = (float)d;
        }
        return new Glue(fArray[0], fArray[1], fArray[2], string);
    }

    private void setTypeMappings() {
        this.typeMappings.put("ord", 0);
        this.typeMappings.put("op", 1);
        this.typeMappings.put("bin", 2);
        this.typeMappings.put("rel", 3);
        this.typeMappings.put("open", 4);
        this.typeMappings.put("close", 5);
        this.typeMappings.put("punct", 6);
        this.typeMappings.put("inner", 7);
    }

    public Glue[] getGlueTypes() {
        return this.glueTypes;
    }

    public int[][][] createGlueTable() throws ResourceParseException {
        int n = this.typeMappings.size();
        int[][][] nArray = new int[n][n][this.styleMappings.size()];
        Element element = (Element)this.root.getElementsByTagName("GlueTable").item(0);
        if (element != null) {
            NodeList nodeList = element.getElementsByTagName("Glue");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element2 = (Element)nodeList.item(i);
                String string = GlueSettingsParser.getAttrValueAndCheckIfNotNull("lefttype", element2);
                String string2 = GlueSettingsParser.getAttrValueAndCheckIfNotNull("righttype", element2);
                String string3 = GlueSettingsParser.getAttrValueAndCheckIfNotNull("gluetype", element2);
                NodeList nodeList2 = element2.getElementsByTagName("Style");
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element element3 = (Element)nodeList2.item(j);
                    String string4 = GlueSettingsParser.getAttrValueAndCheckIfNotNull("name", element3);
                    Integer n2 = this.typeMappings.get(string);
                    Integer n3 = this.typeMappings.get(string2);
                    Integer n4 = this.styleMappings.get(string4);
                    Integer n5 = this.glueTypeMappings.get(string3);
                    GlueSettingsParser.checkMapping(n2, "Glue", "lefttype", string);
                    GlueSettingsParser.checkMapping(n3, "Glue", "righttype", string2);
                    GlueSettingsParser.checkMapping(n5, "Glue", "gluetype", string3);
                    GlueSettingsParser.checkMapping(n4, "Style", "name", string4);
                    nArray[n2.intValue()][n3.intValue()][n4.intValue()] = n5;
                }
            }
        }
        return nArray;
    }

    private static void checkMapping(Object object, String string, String string2, String string3) throws ResourceParseException {
        if (object == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, string, string2, "has an unknown value '" + string3 + "'!");
        }
    }

    private static String getAttrValueAndCheckIfNotNull(String string, Element element) throws ResourceParseException {
        String string2 = element.getAttribute(string);
        if (string2.equals("")) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getTagName(), string, null);
        }
        return string2;
    }
}

