/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import org.gradle.api.internal.GradleInternal;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.invocation.BuildActionRunner;
import org.gradle.internal.invocation.BuildController;
import org.gradle.tooling.internal.provider.BuildClientSubscriptions;
import org.gradle.tooling.internal.provider.SubscribableBuildAction;
import org.gradle.tooling.internal.provider.runner.ClientForwardingBuildListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingTaskListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingTestListener;

public class SubscribableBuildActionRunner
implements BuildActionRunner {
    private BuildActionRunner delegate;

    public SubscribableBuildActionRunner(BuildActionRunner delegate) {
        this.delegate = delegate;
    }

    private void registerListenersForClientSubscriptions(BuildClientSubscriptions clientSubscriptions, GradleInternal gradle) {
        BuildEventConsumer eventConsumer = (BuildEventConsumer)gradle.getServices().get(BuildEventConsumer.class);
        if (clientSubscriptions.isSendTestProgressEvents()) {
            gradle.addListener((Object)new ClientForwardingTestListener(eventConsumer, clientSubscriptions));
        }
        if (clientSubscriptions.isSendTaskProgressEvents()) {
            gradle.addListener((Object)new ClientForwardingTaskListener(eventConsumer, clientSubscriptions));
        }
        if (clientSubscriptions.isSendBuildProgressEvents()) {
            gradle.addListener((Object)new ClientForwardingBuildListener(eventConsumer));
        }
    }

    public void run(BuildAction action, BuildController buildController) {
        if (!(action instanceof SubscribableBuildAction)) {
            return;
        }
        GradleInternal gradle = buildController.getGradle();
        SubscribableBuildAction subscribableBuildAction = (SubscribableBuildAction)action;
        this.registerListenersForClientSubscriptions(subscribableBuildAction.getClientSubscriptions(), gradle);
        this.delegate.run(action, buildController);
    }
}

