/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache;

import com.google.common.collect.MapMaker;
import java.util.Map;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.InMemoryCacheStats;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.InMemoryCachedModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.memcache.InMemoryModuleComponentRepositoryCaches;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.Stoppable;

public class InMemoryCachedRepositoryFactory
implements Stoppable {
    public static final String TOGGLE_PROPERTY = "org.gradle.resolution.memorycache";
    private static final Logger LOG = Logging.getLogger(InMemoryCachedRepositoryFactory.class);
    Map<String, InMemoryModuleComponentRepositoryCaches> cachePerRepo = new MapMaker().makeMap();
    final InMemoryCacheStats stats = new InMemoryCacheStats();

    public ModuleComponentRepository cached(ModuleComponentRepository input) {
        if ("false".equalsIgnoreCase(System.getProperty(TOGGLE_PROPERTY))) {
            return input;
        }
        InMemoryModuleComponentRepositoryCaches caches = this.cachePerRepo.get(input.getId());
        ++this.stats.reposWrapped;
        if (caches == null) {
            LOG.debug("Creating new in-memory cache for repo '{}' [{}].", (Object)input.getName(), (Object)input.getId());
            caches = new InMemoryModuleComponentRepositoryCaches(this.stats);
            ++this.stats.cacheInstances;
            this.cachePerRepo.put(input.getId(), caches);
        } else {
            LOG.debug("Reusing in-memory cache for repo '{}' [{}].", (Object)input.getName(), (Object)input.getId());
        }
        return new InMemoryCachedModuleComponentRepository(caches, input);
    }

    public void stop() {
        this.cachePerRepo.clear();
        LOG.debug("In-memory dependency metadata cache closed. {}", (Object)this.stats);
    }
}

