/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.filestore.ivy;

import org.gradle.api.Transformer;
import org.gradle.api.internal.artifacts.repositories.resolver.IvyResourcePattern;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetaData;
import org.gradle.internal.resource.local.GroupedAndNamedUniqueFileStore;
import org.gradle.internal.resource.local.PathKeyFileStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactIdentifierFileStore
extends GroupedAndNamedUniqueFileStore<ModuleComponentArtifactMetaData> {
    private static final String GROUP_PATTERN = "[organisation]/[module](/[branch])/[revision]";
    private static final String NAME_PATTERN = "[artifact]-[revision](-[classifier])(.[ext])";

    public ArtifactIdentifierFileStore(PathKeyFileStore pathKeyFileStore, TemporaryFileProvider temporaryFileProvider) {
        super(pathKeyFileStore, temporaryFileProvider, ArtifactIdentifierFileStore.toTransformer(GROUP_PATTERN), ArtifactIdentifierFileStore.toTransformer(NAME_PATTERN));
    }

    private static Transformer<String, ModuleComponentArtifactMetaData> toTransformer(String pattern) {
        final IvyResourcePattern resourcePattern = new IvyResourcePattern(pattern);
        return new Transformer<String, ModuleComponentArtifactMetaData>(){

            public String transform(ModuleComponentArtifactMetaData artifact) {
                return resourcePattern.getLocation(artifact).getPath();
            }
        };
    }
}

