/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Contextual
public class ModuleVersionResolveException
extends DefaultMultiCauseException {
    private final List<List<ModuleVersionIdentifier>> paths = new ArrayList<List<ModuleVersionIdentifier>>();
    private final ComponentSelector selector;

    public ModuleVersionResolveException(ComponentSelector selector, String message) {
        super(message);
        this.selector = selector;
    }

    public ModuleVersionResolveException(ComponentSelector selector, Throwable cause) {
        this(selector, ModuleVersionResolveException.format("Could not resolve %s.", selector));
        this.initCause(cause);
    }

    public ModuleVersionResolveException(ComponentSelector selector, Iterable<? extends Throwable> causes) {
        this(selector, ModuleVersionResolveException.format("Could not resolve %s.", selector));
        this.initCauses(causes);
    }

    public ModuleVersionResolveException(ModuleVersionSelector selector, String message) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(selector.getGroup(), selector.getName(), selector.getVersion()), message);
    }

    public ModuleVersionResolveException(ModuleVersionIdentifier id, String message) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(id.getGroup(), id.getName(), id.getVersion()), message);
    }

    public ModuleVersionResolveException(ModuleComponentIdentifier id, String messageFormat) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(id.getGroup(), id.getModule(), id.getVersion()), messageFormat);
    }

    public ModuleVersionResolveException(ModuleComponentIdentifier id, Throwable cause) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(id.getGroup(), id.getModule(), id.getVersion()), Arrays.asList(cause));
    }

    public ModuleVersionResolveException(ModuleComponentIdentifier id, Iterable<? extends Throwable> causes) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(id.getGroup(), id.getModule(), id.getVersion()), causes);
    }

    public ModuleVersionResolveException(ModuleVersionSelector selector, Throwable cause) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(selector.getGroup(), selector.getName(), selector.getVersion()), cause);
    }

    public ModuleVersionResolveException(ModuleVersionSelector selector, Iterable<? extends Throwable> causes) {
        this((ComponentSelector)DefaultModuleComponentSelector.newSelector(selector.getGroup(), selector.getName(), selector.getVersion()), causes);
    }

    public ComponentSelector getSelector() {
        return this.selector;
    }

    protected static String format(String messageFormat, ComponentSelector selector) {
        return String.format(messageFormat, selector.getDisplayName());
    }

    public ModuleVersionResolveException withIncomingPaths(Collection<? extends List<ModuleVersionIdentifier>> paths) {
        ModuleVersionResolveException copy = this.createCopy();
        copy.paths.addAll(paths);
        copy.initCauses(this.getCauses());
        copy.setStackTrace(this.getStackTrace());
        return copy;
    }

    public String getMessage() {
        if (this.paths.isEmpty()) {
            return super.getMessage();
        }
        Formatter formatter = new Formatter();
        formatter.format("%s%nRequired by:", super.getMessage());
        for (List<ModuleVersionIdentifier> path : this.paths) {
            formatter.format("%n    %s", this.toString(path.get(0)));
            for (int i = 1; i < path.size(); ++i) {
                formatter.format(" > %s", this.toString(path.get(i)));
            }
        }
        return formatter.toString();
    }

    private String toString(ModuleVersionIdentifier identifier) {
        return identifier.toString();
    }

    protected ModuleVersionResolveException createCopy() {
        try {
            return (ModuleVersionResolveException)((Object)((Object)((Object)this)).getClass().getConstructor(ComponentSelector.class, String.class).newInstance(this.selector, this.getMessage()));
        }
        catch (Exception e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }
}

