/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gradle.api.internal.collections.CollectionFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredCollection<T, S extends T>
implements Collection<S> {
    protected final Collection<T> collection;
    protected final CollectionFilter<S> filter;

    public FilteredCollection(Collection<T> collection, CollectionFilter<S> filter) {
        this.collection = collection;
        this.filter = filter;
    }

    @Override
    public boolean add(S o) {
        throw new UnsupportedOperationException(String.format("Cannot add '%s' to '%s' as it is a filtered collection", o, this));
    }

    @Override
    public boolean addAll(Collection<? extends S> c) {
        throw new UnsupportedOperationException(String.format("Cannot add all from '%s' to '%s' as it is a filtered collection", c, this));
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(String.format("Cannot clear '%s' as it is a filtered collection", this));
    }

    protected boolean accept(Object o) {
        return this.filter.filter(o) != null;
    }

    @Override
    public boolean contains(Object o) {
        return this.collection.contains(o) && this.accept(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.collection.containsAll(c)) {
            for (Object o : c) {
                if (this.accept(o)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        if (this.collection.isEmpty()) {
            return true;
        }
        for (T o : this.collection) {
            if (!this.accept(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<S> iterator() {
        return new FilteringIterator<T, S>(this.collection.iterator(), this.filter);
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(String.format("Cannot remove '%s' from '%s' as it is a filtered collection", o, this));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(String.format("Cannot remove all of '%s' from '%s' as it is a filtered collection", c, this));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(String.format("Cannot retain all of '%s' from '%s' as it is a filtered collection", c, this));
    }

    @Override
    public int size() {
        int i = 0;
        for (T o : this.collection) {
            if (!this.accept(o)) continue;
            ++i;
        }
        return i;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.size()];
        int i = 0;
        for (T o : this.collection) {
            if (!this.accept(o)) continue;
            a[i++] = o;
        }
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FilteringIterator<T, S extends T>
    implements Iterator<S> {
        private final CollectionFilter<S> filter;
        private final Iterator<T> iterator;
        private S next;

        public FilteringIterator(Iterator<T> iterator, CollectionFilter<S> filter) {
            this.iterator = iterator;
            this.filter = filter;
            this.next = this.findNext();
        }

        private S findNext() {
            while (this.iterator.hasNext()) {
                T potentialNext = this.iterator.next();
                S filtered = this.filter.filter(potentialNext);
                if (filtered == null) continue;
                return filtered;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public S next() {
            if (this.next != null) {
                S thisNext = this.next;
                this.next = this.findNext();
                return thisNext;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator does not support removal");
        }
    }
}

