/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderId;

class ClassLoaderScopeIdentifier {
    private final ClassLoaderScopeIdentifier parent;
    private final String name;

    public ClassLoaderScopeIdentifier(ClassLoaderScopeIdentifier parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    public ClassLoaderScopeIdentifier child(String name) {
        return new ClassLoaderScopeIdentifier(this, name);
    }

    ClassLoaderId localId() {
        return new Id(this, false);
    }

    ClassLoaderId exportId() {
        return new Id(this, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassLoaderScopeIdentifier that = (ClassLoaderScopeIdentifier)o;
        return this.name.equals(that.name) && !(this.parent == null ? that.parent != null : !this.parent.equals(that.parent));
    }

    public int hashCode() {
        int result = this.parent != null ? this.parent.hashCode() : 0;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    private String getPath() {
        LinkedList names = Lists.newLinkedList();
        names.add(this.name);
        ClassLoaderScopeIdentifier nextParent = this.parent;
        while (nextParent != null) {
            names.add(0, nextParent.name);
            nextParent = nextParent.parent;
        }
        return Joiner.on((String)":").join((Iterable)names);
    }

    public String toString() {
        return "ClassLoaderScopeIdentifier{" + this.getPath() + "}";
    }

    private static class Id
    implements ClassLoaderId {
        private final ClassLoaderScopeIdentifier identifier;
        private final boolean export;

        public Id(ClassLoaderScopeIdentifier identifier, boolean export) {
            this.identifier = identifier;
            this.export = export;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Id id = (Id)o;
            return this.export == id.export && this.identifier.equals(id.identifier);
        }

        public int hashCode() {
            int result = this.identifier.hashCode();
            result = 31 * result + (this.export ? 1 : 0);
            return result;
        }

        public String toString() {
            return "ClassLoaderScopeIdentifier.Id{" + this.identifier.getPath() + "(" + (this.export ? "export" : "local") + ")}";
        }
    }
}

