/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.launcher;

import java.io.DataInputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.process.internal.child.EncodedStream;

public class GradleWorkerMain {
    public void run() throws Exception {
        DataInputStream instr = new DataInputStream(new EncodedStream.EncodedInput(System.in));
        int classPathLength = instr.readInt();
        URL[] infrastructureClassPath = new URL[classPathLength];
        for (int i = 0; i < classPathLength; ++i) {
            String url = instr.readUTF();
            infrastructureClassPath[i] = new URL(url);
        }
        int logLevel = instr.readInt();
        int sharedPackagesCount = instr.readInt();
        ArrayList<String> sharedPackages = new ArrayList<String>(sharedPackagesCount);
        for (int i = 0; i < sharedPackagesCount; ++i) {
            sharedPackages.add(instr.readUTF());
        }
        classPathLength = instr.readInt();
        ArrayList<URL> implementationClassPath = new ArrayList<URL>(classPathLength);
        for (int i = 0; i < classPathLength; ++i) {
            String url = instr.readUTF();
            implementationClassPath.add(new URL(url));
        }
        int serializedWorkerLength = instr.readInt();
        byte[] serializedWorker = new byte[serializedWorkerLength];
        instr.readFully(serializedWorker);
        URLClassLoader classLoader = new URLClassLoader(infrastructureClassPath, ClassLoader.getSystemClassLoader().getParent());
        Class<Callable> workerClass = classLoader.loadClass("org.gradle.process.internal.child.SystemApplicationClassLoaderWorker").asSubclass(Callable.class);
        Callable main = workerClass.getConstructor(Integer.TYPE, Collection.class, Collection.class, byte[].class).newInstance(logLevel, sharedPackages, implementationClassPath, serializedWorker);
        main.call();
    }

    public static void main(String[] args) {
        try {
            new GradleWorkerMain().run();
            System.exit(0);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

