/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.gradle.api.Nullable;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelTypeInitializationException;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.extract.ManagedImplStructNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ManagedSetNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelMapNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ModelSetNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.NodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ScalarCollectionNodeInitializerExtractionStrategy;
import org.gradle.model.internal.manage.schema.extract.ScalarTypes;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNodeInitializerRegistry
implements NodeInitializerRegistry {
    public static final ModelReference<NodeInitializerRegistry> DEFAULT_REFERENCE = ModelReference.of("nodeInitializerRegistry", NodeInitializerRegistry.class);
    private final List<NodeInitializerExtractionStrategy> allStrategies;
    private final List<NodeInitializerExtractionStrategy> additionalStrategies;
    private final ModelSchemaStore schemaStore;
    private final ScalarCollectionNodeInitializerExtractionStrategy scalarCollectionNodeInitializerExtractionStrategy;
    private final ManagedSetNodeInitializerExtractionStrategy managedSetNodeInitializerExtractionStrategy;
    private final ModelMapNodeInitializerExtractionStrategy modelMapNodeInitializerExtractionStrategy;
    private final ModelSetNodeInitializerExtractionStrategy modelSetNodeInitializerExtractionStrategy;

    public DefaultNodeInitializerRegistry(ModelSchemaStore schemaStore) {
        this(schemaStore, new ManagedProxyFactory());
    }

    public DefaultNodeInitializerRegistry(ModelSchemaStore schemaStore, ManagedProxyFactory proxyFactory) {
        this.schemaStore = schemaStore;
        this.scalarCollectionNodeInitializerExtractionStrategy = new ScalarCollectionNodeInitializerExtractionStrategy();
        this.managedSetNodeInitializerExtractionStrategy = new ManagedSetNodeInitializerExtractionStrategy();
        this.modelMapNodeInitializerExtractionStrategy = new ModelMapNodeInitializerExtractionStrategy(this);
        this.modelSetNodeInitializerExtractionStrategy = new ModelSetNodeInitializerExtractionStrategy();
        this.allStrategies = Lists.newArrayList((Object[])new NodeInitializerExtractionStrategy[]{this.modelSetNodeInitializerExtractionStrategy, this.managedSetNodeInitializerExtractionStrategy, this.modelMapNodeInitializerExtractionStrategy, this.scalarCollectionNodeInitializerExtractionStrategy, new ManagedImplStructNodeInitializerExtractionStrategy(schemaStore, proxyFactory)});
        this.additionalStrategies = Lists.newArrayList();
    }

    public ModelTypeInitializationException canNotConstructTypeException(NodeInitializerContext context) {
        Iterable scalars = Iterables.concat(ScalarTypes.TYPES, ScalarTypes.NON_FINAL_TYPES);
        TreeSet constructableTypes = new TreeSet(new Comparator<ModelType<?>>(){

            @Override
            public int compare(ModelType<?> o1, ModelType<?> o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        for (NodeInitializerExtractionStrategy extractor : this.additionalStrategies) {
            Iterables.addAll(constructableTypes, extractor.supportedTypes());
        }
        return new ModelTypeInitializationException(context, this.schemaStore, scalars, constructableTypes);
    }

    @Override
    public NodeInitializer getNodeInitializer(NodeInitializerContext nodeInitializerContext) {
        NodeInitializer nodeInitializer = this.findNodeInitializer(nodeInitializerContext.getModelType());
        if (nodeInitializer != null) {
            return nodeInitializer;
        }
        throw this.canNotConstructTypeException(nodeInitializerContext);
    }

    @Nullable
    public NodeInitializer findNodeInitializer(ModelType<?> type) {
        ModelSchema<?> schema = this.schemaStore.getSchema(type);
        for (NodeInitializerExtractionStrategy extractor : this.allStrategies) {
            NodeInitializer nodeInitializer = extractor.extractNodeInitializer(schema);
            if (nodeInitializer == null) continue;
            return nodeInitializer;
        }
        return null;
    }

    @Override
    public void ensureHasInitializer(NodeInitializerContext nodeInitializer) {
        this.getNodeInitializer(nodeInitializer);
    }

    @Override
    public void registerStrategy(NodeInitializerExtractionStrategy strategy) {
        this.allStrategies.add(0, strategy);
        this.additionalStrategies.add(0, strategy);
    }

    @Override
    public <T> boolean hasNodeInitializer(ModelType<T> type) {
        return null != this.findNodeInitializer(type);
    }
}

