/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.cache;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.cache.WeakClassSet;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ModelSchemaCache {
    private final HashMap<WeakClassSet, Map<ModelType<?>, ModelSchema<?>>> cache = Maps.newHashMap();
    private final Lock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> ModelSchema<T> get(ModelType<T> type) {
        this.lock.lock();
        try {
            Map<ModelType<?>, ModelSchema<?>> typeCache = this.cache.get(WeakClassSet.of(type));
            if (typeCache == null) {
                ModelSchema<T> modelSchema = null;
                return modelSchema;
            }
            ModelSchema modelSchema = (ModelSchema)Cast.uncheckedCast(typeCache.get(type));
            return modelSchema;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void set(ModelType<T> type, ModelSchema<T> schema) {
        this.lock.lock();
        try {
            HashMap typeCache = this.cache.get(WeakClassSet.of(type));
            if (typeCache == null) {
                typeCache = Maps.newHashMap();
                this.cache.put(WeakClassSet.of(type), typeCache);
            }
            typeCache.put(type, schema);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        this.lock.lock();
        this.cleanUp();
        try {
            long size = 0L;
            for (Map<ModelType<?>, ModelSchema<?>> values : this.cache.values()) {
                size += (long)values.size();
            }
            long l = size;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() {
        this.lock.lock();
        try {
            Iterator<Map.Entry<WeakClassSet, Map<ModelType<?>, ModelSchema<?>>>> iterator = this.cache.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getKey().isCollected()) continue;
                iterator.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

