/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.language.nativeplatform.internal.Include;
import org.gradle.language.nativeplatform.internal.SourceIncludes;
import org.gradle.language.nativeplatform.internal.incremental.ResolvedInclude;
import org.gradle.language.nativeplatform.internal.incremental.SourceIncludesResolver;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSourceIncludesResolver
implements SourceIncludesResolver {
    private final List<File> includePaths;

    public DefaultSourceIncludesResolver(List<File> includePaths) {
        this.includePaths = includePaths;
    }

    @Override
    public Set<ResolvedInclude> resolveIncludes(File sourceFile, SourceIncludes includes) {
        LinkedHashSet<ResolvedInclude> dependencies = new LinkedHashSet<ResolvedInclude>();
        this.searchForDependencies(dependencies, this.prependSourceDir(sourceFile, this.includePaths), includes.getQuotedIncludes());
        this.searchForDependencies(dependencies, this.includePaths, includes.getSystemIncludes());
        if (!includes.getMacroIncludes().isEmpty()) {
            dependencies.add(new ResolvedInclude(((Include)includes.getMacroIncludes().get(0)).getValue(), null));
        }
        return dependencies;
    }

    private List<File> prependSourceDir(File sourceFile, List<File> includePaths) {
        ArrayList<File> quotedSearchPath = new ArrayList<File>(includePaths.size() + 1);
        quotedSearchPath.add(sourceFile.getParentFile());
        quotedSearchPath.addAll(includePaths);
        return quotedSearchPath;
    }

    private void searchForDependencies(Set<ResolvedInclude> dependencies, List<File> searchPath, List<Include> includes) {
        for (Include include : includes) {
            this.searchForDependency(dependencies, searchPath, include.getValue());
        }
    }

    private void searchForDependency(Set<ResolvedInclude> dependencies, List<File> searchPath, String include) {
        for (File searchDir : searchPath) {
            File candidate = new File(searchDir, include);
            if (!candidate.isFile()) continue;
            dependencies.add(new ResolvedInclude(include, GFileUtils.canonicalise((File)candidate)));
            return;
        }
    }
}

