/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;

public class JsonLocationInstantiator
extends ValueInstantiator {
    public static final JsonLocationInstantiator instance = new JsonLocationInstantiator();

    @Override
    public String getValueTypeDesc() {
        return JsonLocation.class.getName();
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return true;
    }

    public CreatorProperty[] getFromObjectArguments(DeserializationConfig deserializationConfig) {
        JavaType javaType = deserializationConfig.constructType(Integer.TYPE);
        JavaType javaType2 = deserializationConfig.constructType(Long.TYPE);
        return new CreatorProperty[]{JsonLocationInstantiator.creatorProp("sourceRef", deserializationConfig.constructType(Object.class), 0), JsonLocationInstantiator.creatorProp("byteOffset", javaType2, 1), JsonLocationInstantiator.creatorProp("charOffset", javaType2, 2), JsonLocationInstantiator.creatorProp("lineNr", javaType, 3), JsonLocationInstantiator.creatorProp("columnNr", javaType, 4)};
    }

    private static CreatorProperty creatorProp(String string, JavaType javaType, int n) {
        return new CreatorProperty(new PropertyName(string), javaType, null, null, null, null, n, null, PropertyMetadata.STD_REQUIRED);
    }

    @Override
    public Object createFromObjectWith(DeserializationContext deserializationContext, Object[] objectArray) {
        return new JsonLocation(objectArray[0], JsonLocationInstantiator._long(objectArray[1]), JsonLocationInstantiator._long(objectArray[2]), JsonLocationInstantiator._int(objectArray[3]), JsonLocationInstantiator._int(objectArray[4]));
    }

    private static final long _long(Object object) {
        return object == null ? 0L : ((Number)object).longValue();
    }

    private static final int _int(Object object) {
        return object == null ? 0 : ((Number)object).intValue();
    }
}

