/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.report;

import java.math.BigDecimal;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.api.internal.tasks.testing.junit.report.TestResult;
import org.gradle.api.internal.tasks.testing.junit.report.TestResultModel;
import org.gradle.api.tasks.testing.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompositeTestResults
extends TestResultModel {
    private final CompositeTestResults parent;
    private int tests;
    private final Set<TestResult> failures = new TreeSet<TestResult>();
    private final Set<TestResult> ignored = new TreeSet<TestResult>();
    private long duration;

    protected CompositeTestResults(CompositeTestResults parent) {
        this.parent = parent;
    }

    public CompositeTestResults getParent() {
        return this.parent;
    }

    public abstract String getBaseUrl();

    public String getUrlTo(CompositeTestResults model) {
        int pos;
        int endB;
        int endA;
        String otherUrl = model.getBaseUrl();
        String thisUrl = this.getBaseUrl();
        int maxPos = Math.min(thisUrl.length(), otherUrl.length());
        int endPrefix = 0;
        while (endPrefix < maxPos && (endA = thisUrl.indexOf(47, endPrefix)) == (endB = otherUrl.indexOf(47, endPrefix)) && endA >= 0 && thisUrl.regionMatches(endPrefix, otherUrl, endPrefix, endA - endPrefix)) {
            endPrefix = endA + 1;
        }
        StringBuilder result = new StringBuilder();
        int endA2 = endPrefix;
        while (endA2 < thisUrl.length() && (pos = thisUrl.indexOf(47, endA2)) >= 0) {
            result.append("../");
            endA2 = pos + 1;
        }
        result.append(otherUrl.substring(endPrefix));
        return result.toString();
    }

    public int getTestCount() {
        return this.tests;
    }

    public int getFailureCount() {
        return this.failures.size();
    }

    public int getIgnoredCount() {
        return this.ignored.size();
    }

    public int getRunTestCount() {
        return this.tests - this.getIgnoredCount();
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public String getFormattedDuration() {
        return this.getTestCount() == 0 ? "-" : super.getFormattedDuration();
    }

    public Set<TestResult> getFailures() {
        return this.failures;
    }

    public Set<TestResult> getIgnored() {
        return this.ignored;
    }

    @Override
    public TestResult.ResultType getResultType() {
        if (!this.failures.isEmpty()) {
            return TestResult.ResultType.FAILURE;
        }
        if (this.getIgnoredCount() > 0) {
            return TestResult.ResultType.SKIPPED;
        }
        return TestResult.ResultType.SUCCESS;
    }

    public String getFormattedSuccessRate() {
        Number successRate = this.getSuccessRate();
        if (successRate == null) {
            return "-";
        }
        return successRate + "%";
    }

    public Number getSuccessRate() {
        if (this.getRunTestCount() == 0) {
            return null;
        }
        BigDecimal runTests = BigDecimal.valueOf(this.getRunTestCount());
        BigDecimal successful = BigDecimal.valueOf(this.getRunTestCount() - this.getFailureCount());
        return successful.divide(runTests, 2, 1).multiply(BigDecimal.valueOf(100L)).intValue();
    }

    protected void failed(TestResult failedTest) {
        this.failures.add(failedTest);
        if (this.parent != null) {
            this.parent.failed(failedTest);
        }
    }

    protected void ignored(TestResult ignoredTest) {
        this.ignored.add(ignoredTest);
        if (this.parent != null) {
            this.parent.ignored(ignoredTest);
        }
    }

    protected TestResult addTest(TestResult test) {
        ++this.tests;
        this.duration += test.getDuration();
        return test;
    }
}

