/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.tasks.apigen.abi;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.gradle.language.base.internal.tasks.apigen.abi.AnnotationSig;
import org.gradle.language.base.internal.tasks.apigen.abi.ParameterAnnotationSig;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodSig
implements Comparable<MethodSig> {
    private final int access;
    private final String name;
    private final String desc;
    private final String signature;
    private final Set<String> exceptions;
    private final List<AnnotationSig> annotations = Lists.newArrayList();
    private final List<AnnotationSig> parameterAnnotations = Lists.newArrayList();

    public MethodSig(int access, String name, String desc, String signature, String[] exceptions) {
        this.access = access;
        this.name = name;
        this.desc = desc;
        this.signature = signature;
        this.exceptions = exceptions == null ? Collections.emptySet() : Sets.newTreeSet((Iterable)ImmutableList.copyOf((Object[])exceptions));
    }

    public int getAccess() {
        return this.access;
    }

    public String getDesc() {
        return this.desc;
    }

    public Set<String> getExceptions() {
        return this.exceptions;
    }

    public String getName() {
        return this.name;
    }

    public String getSignature() {
        return this.signature;
    }

    public List<AnnotationSig> getAnnotations() {
        return this.annotations;
    }

    public List<AnnotationSig> getParameterAnnotations() {
        return this.parameterAnnotations;
    }

    public AnnotationSig addAnnotation(String desc, boolean visible) {
        AnnotationSig sig = new AnnotationSig(desc, visible);
        this.annotations.add(sig);
        return sig;
    }

    public ParameterAnnotationSig addParameterAnnotation(int param, String desc, boolean visible) {
        ParameterAnnotationSig sig = new ParameterAnnotationSig(desc, visible, param);
        this.parameterAnnotations.add(sig);
        return sig;
    }

    @Override
    public int compareTo(MethodSig o) {
        return ComparisonChain.start().compare(this.access, o.access).compare((Comparable)((Object)this.name), (Comparable)((Object)o.name)).compare((Comparable)((Object)(this.desc == null ? "" : this.desc)), (Comparable)((Object)(o.desc == null ? "" : o.desc))).compare((Comparable)((Object)(this.signature == null ? "" : this.signature)), (Comparable)((Object)(o.signature == null ? "" : o.signature))).compare(this.exceptions, o.exceptions, (Comparator)Ordering.natural().lexicographical()).result();
    }

    public String toString() {
        StringBuilder methodDesc = new StringBuilder();
        methodDesc.append(Modifier.toString(this.access)).append(" ");
        methodDesc.append(Type.getReturnType((String)this.desc).getClassName()).append(" ");
        methodDesc.append(this.name);
        methodDesc.append("(");
        Type[] argumentTypes = Type.getArgumentTypes((String)this.desc);
        int argumentTypesLength = argumentTypes.length;
        for (int i = 0; i < argumentTypesLength; ++i) {
            Type type = argumentTypes[i];
            methodDesc.append(type.getClassName());
            if (i >= argumentTypesLength - 1) continue;
            methodDesc.append(", ");
        }
        methodDesc.append(")");
        return methodDesc.toString();
    }
}

