/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.ObjectInstantiationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectInstantiator
implements Instantiator {
    public static final Instantiator INSTANCE = new DirectInstantiator();

    public static <T> T instantiate(Class<? extends T> type, Object ... params) {
        return INSTANCE.newInstance(type, params);
    }

    private DirectInstantiator() {
    }

    @Override
    public <T> T newInstance(Class<? extends T> type, Object ... params) {
        try {
            ArrayList matches = new ArrayList();
            for (Constructor<?> constructor : type.getConstructors()) {
                if (!this.isMatch(constructor, params)) continue;
                matches.add(constructor);
            }
            if (matches.isEmpty()) {
                throw new IllegalArgumentException(String.format("Could not find any public constructor for %s which accepts parameters %s.", type, Arrays.toString(params)));
            }
            if (matches.size() > 1) {
                throw new IllegalArgumentException(String.format("Found multiple public constructors for %s which accept parameters %s.", type, Arrays.toString(params)));
            }
            return type.cast(((Constructor)matches.get(0)).newInstance(params));
        }
        catch (InvocationTargetException e) {
            throw new ObjectInstantiationException(type, e.getCause());
        }
        catch (Exception e) {
            throw new ObjectInstantiationException(type, (Throwable)e);
        }
    }

    private boolean isMatch(Constructor<?> constructor, Object ... params) {
        if (constructor.getParameterTypes().length != params.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            Class<?> parameterType = constructor.getParameterTypes()[i];
            if (!(parameterType.isPrimitive() ? !JavaReflectionUtil.getWrapperTypeForPrimitiveType(parameterType).isInstance(param) : param != null && !parameterType.isInstance(param))) continue;
            return false;
        }
        return true;
    }
}

