/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import java.io.File;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysis;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassDependentsAccumulator;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassSetAnalysisData;

public class ClassFilesAnalyzer
implements FileVisitor {
    private final ClassDependenciesAnalyzer analyzer;
    private final String packagePrefix;
    private final ClassDependentsAccumulator accumulator;

    public ClassFilesAnalyzer(ClassDependenciesAnalyzer analyzer) {
        this(analyzer, "", new ClassDependentsAccumulator(""));
    }

    ClassFilesAnalyzer(ClassDependenciesAnalyzer analyzer, String packagePrefix, ClassDependentsAccumulator accumulator) {
        this.analyzer = analyzer;
        this.packagePrefix = packagePrefix;
        this.accumulator = accumulator;
    }

    public void visitDir(FileVisitDetails dirDetails) {
    }

    public void visitFile(FileVisitDetails fileDetails) {
        File file = fileDetails.getFile();
        if (!file.getName().endsWith(".class")) {
            return;
        }
        String className = fileDetails.getPath().replaceAll("/", ".").replaceAll("\\.class$", "");
        if (!className.startsWith(this.packagePrefix)) {
            return;
        }
        ClassAnalysis analysis = this.analyzer.getClassAnalysis(className, file);
        this.accumulator.addClass(className, analysis.isDependencyToAll(), analysis.getClassDependencies());
    }

    public ClassSetAnalysisData getAnalysis() {
        return new ClassSetAnalysisData(this.accumulator.getDependentsMap());
    }
}

